/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.shared.utils;

import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsInjector;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsUtils;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.IPluginType;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.PluginType;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class AutoSymlink {
    public static void main(String[] args) throws Exception {
        ExtendedProperties properties = ExtendedProperties.createWith((Properties)PropertyIOUtils.loadProperties((String)"etc/service.properties"));
        CorePluginsUtils.addCorePluginsProperties((Properties)properties, CorePluginScanner.ScannerType.AS);
        PluginType maintenanceTasks = new PluginType("maintenance-tasks", "maintenance-plugins");
        PluginType services = new PluginType("services", "services");
        PluginType miscellaneous = new PluginType("miscellaneous", null);
        CorePluginsInjector injector = new CorePluginsInjector(CorePluginScanner.ScannerType.AS, new IPluginType[]{maintenanceTasks, services, miscellaneous});
        Map<String, File> pluginFolders = injector.injectCorePlugins((Properties)properties);
        AutoSymlink.createSymlinks(new File("webapps/openbis/WEB-INF/lib/"), pluginFolders);
    }

    public static void createSymlinks(File libDir, Map<String, File> pluginFolders) {
        try {
            for (File link : libDir.listFiles()) {
                if (!link.getName().startsWith("autolink-")) continue;
                link.delete();
            }
            for (String key : pluginFolders.keySet()) {
                File pluginLibFolder = new File(pluginFolders.get(key).getCanonicalPath() + "/lib");
                if (!pluginLibFolder.exists()) continue;
                for (File jar : pluginLibFolder.listFiles()) {
                    if (!jar.isFile() || !jar.getName().endsWith(".jar")) continue;
                    String link = libDir.getAbsolutePath() + "/autolink-" + key + "-" + jar.getName();
                    Unix.createSymbolicLink((String)jar.getAbsolutePath(), (String)link);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

