/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.api.gui;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractServlet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class AbstractWebStartClientServingServlet
extends AbstractServlet {
    private static final String SERVER_URL = "server-url";
    private static final String CODEBASE_URL = "codebase-url";
    private final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ((Object)((Object)this)).getClass());

    protected AbstractWebStartClientServingServlet() {
    }

    @Override
    protected void respondToRequest(HttpServletRequest request, HttpServletResponse response) throws Exception, IOException {
        try {
            response.setContentType("application/x-java-jnlp-file");
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
            Template template = this.getJnlpTemplate().createFreshCopy();
            String sessionToken = this.bindTemplateParameters(request, template);
            writer.print(template.createText());
            writer.close();
            if (this.operationLog.isInfoEnabled()) {
                this.operationLog.info((Object)this.getInfoLogText(request, sessionToken));
            }
        }
        catch (UserFailureException ex) {
            this.operationLog.error((Object)"Couldn't create JNLP file", (Throwable)ex);
            this.printError(response, ex.getMessage());
        }
    }

    private String getServiceURL(HttpServletRequest request) {
        String url = this.getParam(request, SERVER_URL);
        try {
            URL baseURL = new URL(url);
            String protocol = baseURL.getProtocol();
            String host = baseURL.getHost();
            int port = baseURL.getPort();
            return new URL(protocol, host, port, "/openbis/openbis/").toString();
        }
        catch (MalformedURLException ex) {
            throw new EnvironmentFailureException("Invalid URL", (Throwable)ex);
        }
    }

    protected String getCodebaseUrl(HttpServletRequest request) {
        return this.getParam(request, CODEBASE_URL);
    }

    private String getParam(HttpServletRequest request, String paramName) {
        String value = request.getParameter(paramName);
        if (value == null) {
            throw new UserFailureException("Missing URL parameter '" + paramName + "'.");
        }
        return value;
    }

    private void printError(HttpServletResponse response, String errorMessage) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.write("<html><body><b>" + errorMessage + "</b></body></html>");
        writer.flush();
        writer.close();
    }

    protected String getInfoLogText(HttpServletRequest request, String sessionToken) {
        return "Launch web start client " + this.getMainClassName() + " for session " + sessionToken;
    }

    protected String bindTemplateParameters(HttpServletRequest request, Template template) {
        template.bind("title", this.getTitle());
        template.bind("description", this.getDescription());
        template.bind("base-URL", this.getCodebaseUrl(request));
        template.bind("main-class", this.getMainClassName());
        template.bind("service-URL", this.getServiceURL(request));
        String sessionToken = this.getSessionToken(request);
        template.bind("session-id", sessionToken);
        return sessionToken;
    }

    protected abstract Template getJnlpTemplate();

    protected abstract String getMainClassName();

    protected abstract String getTitle();

    protected String getDescription() {
        return this.getTitle();
    }
}

