/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.cli;

import ch.systemsx.cisd.args4j.Argument;
import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jline.ConsoleReader;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;

public class Login {
    private static final File OPENBIS_DIR = new File(System.getProperty("user.home"), ".openbis");
    public static final File OPENBIS_TOKEN_FILE = new File(OPENBIS_DIR, "session-token");
    public static final File OPENBIS_USER_FILE = new File(OPENBIS_DIR, "user");
    public static final File OPENBIS_SERVER_URL_FILE = new File(OPENBIS_DIR, "server");

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void write(String server, String user, String token) {
        BufferedWriter bw = null;
        try {
            if (!OPENBIS_DIR.exists()) {
                OPENBIS_DIR.mkdir();
            }
            bw = new BufferedWriter(new FileWriter(OPENBIS_SERVER_URL_FILE));
            bw.write(server);
            bw.close();
            bw = new BufferedWriter(new FileWriter(OPENBIS_USER_FILE));
            bw.write(user);
            bw.close();
            bw = new BufferedWriter(new FileWriter(OPENBIS_TOKEN_FILE));
            bw.write(token);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                Login.closeQuietly(bw);
                throw throwable;
            }
        }
        Login.closeQuietly(bw);
    }

    public static void main(String[] args) throws IOException {
        BasicConfigurator.configure((Appender)new NullAppender());
        try {
            Parameters params = new Parameters(args);
            if (params.getServer() == null) {
                throw new RuntimeException("Server not specified (give '-s').");
            }
            if (params.getUser() == null) {
                throw new RuntimeException("User not specified (give '-u').");
            }
            String password = new ConsoleReader().readLine("Password: ", Character.valueOf('*'));
            if (password == null || password.length() == 0) {
                throw new RuntimeException("Password empty.");
            }
            ServiceFinder generalInformationServiceFinder = new ServiceFinder("openbis", "/rmi-general-information-v1");
            IGeneralInformationService service = (IGeneralInformationService)generalInformationServiceFinder.createService(IGeneralInformationService.class, params.getServer());
            String sessionToken = service.tryToAuthenticateForAllServices(params.getUser(), password);
            if (sessionToken == null) {
                throw new RuntimeException("Login failed.");
            }
            Login.write(params.getServer(), params.getUser(), sessionToken);
        }
        catch (RuntimeException ex) {
            String msg = ex.getMessage();
            if (msg == null && ex.getCause() != null) {
                msg = ex.getCause().getClass().getSimpleName() + ": " + ex.getMessage();
            }
            System.err.println(msg);
            System.exit(1);
        }
    }

    private static class Parameters {
        private final CmdLineParser parser;
        @Argument
        private final List<String> args;
        @Option(name="u", longName="user")
        private String user;
        @Option(name="s", longName="server")
        private String server;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Parameters(String[] args) {
            block7: {
                this.args = new ArrayList<String>();
                this.parser = new CmdLineParser((Object)this);
                try {
                    BufferedReader br;
                    block8: {
                        block9: {
                            this.parser.parseArgument(args);
                            if (this.server != null) break block8;
                            if (!OPENBIS_SERVER_URL_FILE.exists()) break block9;
                            br = null;
                            try {
                                br = new BufferedReader(new FileReader(OPENBIS_SERVER_URL_FILE));
                                this.server = br.readLine();
                                br.close();
                            }
                            catch (Throwable throwable) {
                                Login.closeQuietly(br);
                                throw throwable;
                            }
                            Login.closeQuietly(br);
                            break block8;
                        }
                        this.server = new ConsoleReader().readLine("Server URL: ");
                    }
                    if (this.user != null) break block7;
                    if (OPENBIS_USER_FILE.exists()) {
                        br = null;
                        try {
                            br = new BufferedReader(new FileReader(OPENBIS_USER_FILE));
                            this.user = br.readLine();
                            br.close();
                        }
                        catch (Throwable throwable) {
                            Login.closeQuietly(br);
                            throw throwable;
                        }
                        Login.closeQuietly(br);
                        break block7;
                    }
                    this.user = new ConsoleReader().readLine("User: ");
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
        }

        public List<String> getArgs() {
            return Collections.unmodifiableList(this.args);
        }

        public String getUser() {
            return this.user;
        }

        public String getServer() {
            return this.server;
        }
    }
}

