/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.console;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.openbis.generic.client.console.Assignment;
import ch.systemsx.cisd.openbis.generic.client.console.ICommand;
import ch.systemsx.cisd.openbis.generic.client.console.RegisterPropertyType;
import ch.systemsx.cisd.openbis.generic.client.console.RegisterType;
import ch.systemsx.cisd.openbis.generic.client.console.ScriptContext;
import ch.systemsx.cisd.openbis.generic.client.console.Set;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jline.ConsoleReader;

public class AdminConsole {
    private static final String SERVICE_PATH = "/rmi-common";

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: java -jar openbis-admin-console.jar  <server url> <script path> <user ID> [<password>]");
            System.exit(1);
        }
        String serverURL = args[0];
        String script = args[1];
        String userID = args[2];
        String password = args.length == 4 ? args[3] : AdminConsole.getConsoleReader().readLine("Password: ", Character.valueOf('*'));
        ICommonServer commonService = (ICommonServer)HttpInvokerUtils.createServiceStub(ICommonServer.class, (String)(serverURL + SERVICE_PATH), (long)300000L);
        SessionContextDTO session = commonService.tryAuthenticate(userID, password);
        if (session == null) {
            System.err.println("Authentication failed");
        } else {
            System.out.println("Run script " + script);
            Map<String, ICommand> commands = AdminConsole.createCommands();
            String sessionToken = session.getSessionToken();
            List lines = FileUtilities.loadToStringList((File)new File(script));
            ScriptContext context = new ScriptContext((Properties)ExtendedProperties.getSubset((Properties)System.getProperties(), (String)"openbis.", (boolean)true));
            for (int i = 0; i < lines.size(); ++i) {
                String line = ((String)lines.get(i)).trim();
                if (line.length() <= 0 || line.startsWith("--")) continue;
                int indexOfSpace = line.indexOf(32);
                String command = indexOfSpace < 0 ? line : line.substring(0, indexOfSpace);
                String argument = indexOfSpace < 0 ? "" : line.substring(indexOfSpace).trim();
                argument = context.resolveVariables(argument);
                ICommand cmd = commands.get(command);
                if (cmd == null) {
                    AdminConsole.printError(i, line, "Unknown command: " + command);
                    continue;
                }
                try {
                    cmd.execute(commonService, sessionToken, context, argument);
                    continue;
                }
                catch (RuntimeException ex) {
                    AdminConsole.printError(i, line, ex);
                }
            }
            commonService.logout(sessionToken);
            System.out.println("Done. Processed " + lines.size() + " lines.");
        }
    }

    private static void printError(int lineIndex, String line, Object reason) {
        String message = "Error in line " + (lineIndex + 1) + " [" + line + "]\nReason: " + reason;
        System.err.println(message);
    }

    private static ConsoleReader getConsoleReader() {
        try {
            return new ConsoleReader();
        }
        catch (IOException ex) {
            throw new EnvironmentFailureException("ConsoleReader could not be instantiated.", (Throwable)ex);
        }
    }

    private static Map<String, ICommand> createCommands() {
        HashMap<String, ICommand> map = new HashMap<String, ICommand>();
        map.put("register-property-type", new RegisterPropertyType());
        map.put("register-type", new RegisterType());
        map.put("assign-to", new Assignment());
        map.put("set", new Set());
        return map;
    }
}

