/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.console;

import java.util.ArrayList;
import java.util.List;

class Lexer {
    Lexer() {
    }

    static List<String> extractTokens(String string) {
        ParsingContext context = new ParsingContext();
        State state = State.BETWEEN_TOKENS;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            state = state.next(string.charAt(i), context);
        }
        return context.getTokens();
    }

    private static enum State {
        BETWEEN_TOKENS{

            @Override
            public State next(char character, ParsingContext context) {
                if (Character.isWhitespace(character)) {
                    return this;
                }
                if (character == '\"') {
                    return IN_QUOTED_TOKEN;
                }
                context.addCharacter(character);
                return IN_TOKEN;
            }
        }
        ,
        IN_TOKEN{

            @Override
            public State next(char character, ParsingContext context) {
                if (Character.isWhitespace(character)) {
                    context.finishToken();
                    return BETWEEN_TOKENS;
                }
                if (character == '\"') {
                    return IN_QUOTED_TOKEN;
                }
                context.addCharacter(character);
                return this;
            }
        }
        ,
        IN_QUOTED_TOKEN{

            @Override
            public State next(char character, ParsingContext context) {
                if (character == '\"') {
                    return IN_TOKEN;
                }
                context.addCharacter(character);
                return this;
            }
        };


        abstract State next(char var1, ParsingContext var2);
    }

    private static class ParsingContext {
        private final List<String> tokens = new ArrayList<String>();
        private final StringBuilder builder = new StringBuilder();

        private ParsingContext() {
        }

        public void addCharacter(char character) {
            this.builder.append(character);
        }

        public void finishToken() {
            this.tokens.add(this.builder.toString());
            this.builder.setLength(0);
        }

        public List<String> getTokens() {
            if (this.builder.length() > 0) {
                this.finishToken();
            }
            return this.tokens;
        }
    }
}

