/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.console;

import ch.systemsx.cisd.openbis.generic.client.console.AbstractRegisterEntityType;
import ch.systemsx.cisd.openbis.generic.client.console.AttributeSetter;
import ch.systemsx.cisd.openbis.generic.client.console.ICommand;
import ch.systemsx.cisd.openbis.generic.client.console.ScriptContext;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import java.util.HashMap;
import java.util.Map;

class RegisterDataSetType
extends AbstractRegisterEntityType<DataSetType>
implements ICommand {
    private static final Map<String, AttributeSetter<DataSetType>> attributeSetters = new HashMap<String, AttributeSetter<DataSetType>>();

    RegisterDataSetType() {
    }

    @Override
    protected Map<String, AttributeSetter<DataSetType>> attributeSetters() {
        return attributeSetters;
    }

    @Override
    public void execute(ICommonServer server, String sessionToken, ScriptContext context, String argument) {
        server.registerDataSetType(sessionToken, this.prepareEntityType(new DataSetType(), argument));
    }

    static {
        for (DataSetTypeAttributeSetter attributeSetter : DataSetTypeAttributeSetter.values()) {
            attributeSetters.put(attributeSetter.getAttributeName(), attributeSetter);
        }
    }

    private static enum DataSetTypeAttributeSetter implements AttributeSetter<DataSetType>
    {
        DESCRIPTION("description"){

            @Override
            public void setAttributeFor(DataSetType type, String value) {
                type.setDescription(value);
            }
        }
        ,
        PATTERN("main-pattern"){

            @Override
            public void setAttributeFor(DataSetType type, String value) {
                type.setMainDataSetPattern(value);
            }
        }
        ,
        PATH("main-path"){

            @Override
            public void setAttributeFor(DataSetType type, String value) {
                type.setMainDataSetPath(value);
            }
        };

        private final String attributeName;

        private DataSetTypeAttributeSetter(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public void setDefaultFor(DataSetType type) {
        }
    }
}

