/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.console;

import ch.systemsx.cisd.openbis.generic.client.console.AbstractRegisterEntityType;
import ch.systemsx.cisd.openbis.generic.client.console.AttributeSetter;
import ch.systemsx.cisd.openbis.generic.client.console.ICommand;
import ch.systemsx.cisd.openbis.generic.client.console.ScriptContext;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import java.util.HashMap;
import java.util.Map;

public class RegisterSampleType
extends AbstractRegisterEntityType<SampleType>
implements ICommand {
    private static final Map<String, AttributeSetter<SampleType>> attributeSetters = new HashMap<String, AttributeSetter<SampleType>>();

    @Override
    protected Map<String, AttributeSetter<SampleType>> attributeSetters() {
        return attributeSetters;
    }

    @Override
    public void execute(ICommonServer server, String sessionToken, ScriptContext context, String argument) {
        server.registerSampleType(sessionToken, this.prepareEntityType(new SampleType(), argument));
    }

    static {
        for (SampleTypeAttributeSetter setter : SampleTypeAttributeSetter.values()) {
            attributeSetters.put(setter.getAttributeName(), setter);
        }
    }

    private static enum SampleTypeAttributeSetter implements AttributeSetter<SampleType>
    {
        DESCRIPTION("description"){

            @Override
            public void setAttributeFor(SampleType sampleType, String value) {
                sampleType.setDescription(value);
            }
        }
        ,
        LISTABLE("listable"){

            @Override
            public void setAttributeFor(SampleType sampleType, String value) {
                sampleType.setListable(Boolean.parseBoolean(value));
            }
        }
        ,
        SHOW_CONTAINER("show-container"){

            @Override
            public void setAttributeFor(SampleType sampleType, String value) {
                sampleType.setShowContainer(Boolean.parseBoolean(value));
            }
        }
        ,
        SHOW_PARENTS("show-parents"){

            @Override
            public void setAttributeFor(SampleType sampleType, String value) {
                sampleType.setShowParents(Boolean.parseBoolean(value));
            }
        }
        ,
        UNIQUE_SUBCODES("unique-subcodes"){

            @Override
            public void setAttributeFor(SampleType sampleType, String value) {
                sampleType.setSubcodeUnique(Boolean.parseBoolean(value));
            }
        }
        ,
        AUTO_GENERATE_CODES("auto-generate-codes"){

            @Override
            public void setAttributeFor(SampleType sampleType, String value) {
                sampleType.setAutoGeneratedCode(Boolean.parseBoolean(value));
            }
        }
        ,
        GENERATED_CODES_PREFIX("generated-codes-prefix"){

            @Override
            public void setAttributeFor(SampleType sampleType, String value) {
                sampleType.setGeneratedCodePrefix(value);
            }

            @Override
            public void setDefaultFor(SampleType sampleType) {
                sampleType.setGeneratedCodePrefix("S");
            }
        };

        private final String attributeName;

        private SampleTypeAttributeSetter(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public void setDefaultFor(SampleType sampleType) {
        }
    }
}

