/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.CallbackListenerAdapter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ICallbackListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IOnSuccessAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.InvalidSessionException;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import com.extjs.gxt.ui.client.event.WindowEvent;
import com.extjs.gxt.ui.client.event.WindowListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.InvocationException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAsyncCallback<T>
implements AsyncCallback<T> {
    private List<IOnSuccessAction<T>> successActions = new ArrayList<IOnSuccessAction<T>>();
    private List<IDelegatedAction> failureActions = new ArrayList<IDelegatedAction>();
    public static final ICallbackListener<Object> DEFAULT_CALLBACK_LISTENER = new CallbackListenerAdapter<Object>(){

        @Override
        public final void onFailureOf(IMessageProvider messageProvider, AbstractAsyncCallback<Object> callback, String failureMessage, Throwable throwable) {
            UserFailureException userException;
            String details;
            String message = GWTUtils.translateToHtmlLineBreaks(failureMessage);
            if (throwable instanceof UserFailureException && (details = GWTUtils.translateToHtmlLineBreaks((userException = (UserFailureException)throwable).getDetails())) != null) {
                GWTUtils.createErrorMessageWithDetailsDialog(messageProvider, message, details).show();
                return;
            }
            GWTUtils.alert("Error", message);
        }
    };
    private static ICallbackListener<?> staticCallbackListener = DEFAULT_CALLBACK_LISTENER;
    private final ICallbackListener<T> callbackListener;
    protected final IViewContext<?> viewContext;
    private final boolean reloadWhenSessionTerminated;

    public void addOnSuccessAction(IOnSuccessAction<T> action) {
        this.successActions.add(action);
    }

    public void addOnFailureAction(IDelegatedAction action) {
        this.failureActions.add(action);
    }

    public static final <T> void setStaticCallbackListener(ICallbackListener<T> callbackListener) {
        assert (callbackListener != null) : "Unspecified ICallbackListener implementation.";
        staticCallbackListener = callbackListener;
    }

    public static final ICallbackListener<?> getStaticCallbackListener() {
        return staticCallbackListener;
    }

    public AbstractAsyncCallback(IViewContext<?> viewContext) {
        this(viewContext, false);
    }

    public AbstractAsyncCallback(IViewContext<?> viewContext, ICallbackListener<T> callbackListenerOrNull) {
        this(viewContext, callbackListenerOrNull, true);
    }

    public AbstractAsyncCallback(IViewContext<?> viewContext, boolean reloadWhenSessionTerminated) {
        this(viewContext, null, reloadWhenSessionTerminated);
    }

    private AbstractAsyncCallback(IViewContext<?> viewContext, ICallbackListener<T> callbackListenerOrNull, boolean reloadWhenSessionTerminated) {
        this.viewContext = viewContext;
        this.reloadWhenSessionTerminated = reloadWhenSessionTerminated;
        this.callbackListener = staticCallbackListener != DEFAULT_CALLBACK_LISTENER ? AbstractAsyncCallback.cast(staticCallbackListener) : (callbackListenerOrNull == null ? AbstractAsyncCallback.cast(staticCallbackListener) : callbackListenerOrNull);
        assert (this.callbackListener != null) : "Unspecified ICallbackListener implementation.";
        this.callbackListener.registerCallback(this);
    }

    private static final <T> ICallbackListener<T> cast(ICallbackListener<?> callbackListener) {
        return callbackListener;
    }

    public void finishOnFailure(Throwable caught) {
    }

    protected abstract void process(T var1);

    public String getCallbackId() {
        String id = this.getClass().getName();
        return id;
    }

    public String toString() {
        return this.getCallbackId();
    }

    public final void onFailure(Throwable caught) {
        String message;
        if (this.isIncompatibleServerException(caught)) {
            String sessionExpiredMessage = this.getMessage("session_expired", new Object[0]);
            this.handleSessionTerminated(sessionExpiredMessage, caught);
            return;
        }
        String msg = caught instanceof InvocationException ? (StringUtils.isBlank((String)caught.getMessage()) ? this.getMessage("exception_invocationMessage", new Object[0]) : caught.getMessage()) : (StringUtils.isBlank((String)(message = caught.getMessage())) ? this.getMessage("exception_withoutMessage", caught.getClass().getName()) : message);
        if (caught instanceof InvalidSessionException) {
            this.handleSessionTerminated(msg, caught);
        } else {
            this.callbackListener.onFailureOf(this.viewContext, this, msg, caught);
        }
        for (IDelegatedAction a : this.failureActions) {
            a.execute();
        }
        this.finishOnFailure(caught);
    }

    private boolean isIncompatibleServerException(Throwable caught) {
        return caught instanceof IncompatibleRemoteServiceException;
    }

    private String getMessage(String messageKey, Object ... params) {
        if (this.viewContext != null) {
            return this.viewContext.getMessage(messageKey, params);
        }
        return messageKey;
    }

    private void refreshPageInBrowser() {
        if (this.viewContext != null) {
            this.viewContext.getPageController().reload(true);
        }
    }

    private void handleSessionTerminated(String msg, Throwable caught) {
        if (this.viewContext.isSimpleOrEmbeddedMode()) {
            this.refreshPageInBrowser();
        } else {
            this.showSessionTerminated(msg);
        }
        if (staticCallbackListener != DEFAULT_CALLBACK_LISTENER) {
            this.callbackListener.onFailureOf(this.viewContext, this, msg, caught);
        }
    }

    private void showSessionTerminated(String msg) {
        System.err.println("Session terminated");
        Dialog dialog = new Dialog();
        GWTUtils.setToolTip((Component)dialog, this.getMessage("messagebox_warning", new Object[0]));
        dialog.addText(msg);
        dialog.setHideOnButtonClick(false);
        dialog.setModal(true);
        dialog.setHideOnButtonClick(true);
        dialog.show();
        dialog.addWindowListener(new WindowListener(){

            public void windowHide(WindowEvent we) {
                if (AbstractAsyncCallback.this.reloadWhenSessionTerminated) {
                    AbstractAsyncCallback.this.refreshPageInBrowser();
                }
            }
        });
    }

    public final void onSuccess(final T result) {
        this.performSuccessActionOrIgnore(new IDelegatedAction(){

            @Override
            public void execute() {
                AbstractAsyncCallback.this.doOnSuccess(result);
            }
        });
    }

    private void doOnSuccess(T result) {
        this.process(result);
        for (IOnSuccessAction<T> a : this.successActions) {
            a.execute(result);
        }
        this.callbackListener.finishOnSuccessOf(this, result);
    }

    protected void performSuccessActionOrIgnore(IDelegatedAction successAction) {
        successAction.execute();
    }

    public final void ignore() {
        this.callbackListener.ignoreCallback(this);
    }

    public final void reuse() {
        this.callbackListener.registerCallback(this);
    }
}

