/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.IClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;

public abstract class AbstractClientPluginFactory<V extends IViewContext<? extends IClientServiceAsync>>
implements IClientPluginFactory {
    private final V viewContext;
    private final IModule module;

    protected AbstractClientPluginFactory(IViewContext<ICommonClientServiceAsync> originalViewContext) {
        this.viewContext = this.createViewContext(originalViewContext);
        this.module = this.maybeCreateModule();
    }

    protected abstract V createViewContext(IViewContext<ICommonClientServiceAsync> var1);

    public final V getViewContext() {
        return this.viewContext;
    }

    @Override
    public final IModule tryGetModule() {
        return this.module;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    protected boolean checkEnabledProperty(String technology) {
        return this.viewContext.getModel().getApplicationInfo().isTechnologyEnabled(technology);
    }

    protected abstract IModule maybeCreateModule();

    protected final String getBaseIndexURL() {
        return GWTUtils.getBaseIndexURL();
    }
}

