/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.IClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.GenericViewModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IGenericImageBundle;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IPageController;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplaySettingsManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocatorResolverRegistry;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactoryProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ApplicationInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GenericConstants;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebClientConfiguration;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import java.util.List;

public abstract class AbstractPluginViewContext<T extends IClientServiceAsync>
implements IViewContext<T> {
    private final IViewContext<ICommonClientServiceAsync> commonViewContext;
    private final T service;

    static String getPropertyOrNull(IViewContext<?> viewContext, String key) {
        ApplicationInfo applicationInfo = viewContext.getModel().getApplicationInfo();
        if (applicationInfo == null) {
            return null;
        }
        WebClientConfiguration webClientConfiguration = applicationInfo.getWebClientConfiguration();
        if (webClientConfiguration == null) {
            return null;
        }
        return webClientConfiguration.getPropertyOrNull(viewContext.getTechnology(), key);
    }

    public AbstractPluginViewContext(IViewContext<ICommonClientServiceAsync> commonViewContext) {
        this.commonViewContext = commonViewContext;
        this.addMessageSource(this.getTechnology());
        this.service = this.createClientServiceAsync();
        ServiceDefTarget endpoint = (ServiceDefTarget)this.service;
        endpoint.setServiceEntryPoint(GenericConstants.createServicePath(this.getTechnology()));
        this.initializeLocatorHandlerRegistry(commonViewContext.getLocatorResolverRegistry());
    }

    protected abstract T createClientServiceAsync();

    @Override
    public final T getService() {
        return this.service;
    }

    @Override
    public String getPropertyOrNull(String key) {
        return AbstractPluginViewContext.getPropertyOrNull(this, key);
    }

    @Override
    public final IViewContext<ICommonClientServiceAsync> getCommonViewContext() {
        return this.commonViewContext;
    }

    @Override
    public final ICommonClientServiceAsync getCommonService() {
        return this.commonViewContext.getService();
    }

    @Override
    public final GenericViewModel getModel() {
        return this.commonViewContext.getModel();
    }

    @Override
    public void initDisplaySettingsManager() {
        this.commonViewContext.initDisplaySettingsManager();
    }

    @Override
    public DisplaySettingsManager getDisplaySettingsManager() {
        return this.commonViewContext.getDisplaySettingsManager();
    }

    @Override
    public final IPageController getPageController() {
        return this.commonViewContext.getPageController();
    }

    @Override
    public final IClientPluginFactoryProvider getClientPluginFactoryProvider() {
        return this.commonViewContext.getClientPluginFactoryProvider();
    }

    @Override
    public final IGenericImageBundle getImageBundle() {
        return this.commonViewContext.getImageBundle();
    }

    @Override
    public boolean isDebuggingEnabled() {
        return this.commonViewContext.isDebuggingEnabled();
    }

    @Override
    public int log(String description) {
        return this.commonViewContext.log(description);
    }

    @Override
    public void log(int taskId, String description) {
        this.commonViewContext.log(taskId, description);
    }

    @Override
    public void logStop(int taskId) {
        this.commonViewContext.logStop(taskId);
    }

    @Override
    public void clearLog() {
        this.commonViewContext.clearLog();
    }

    @Override
    public List<String> getLoggedEvents() {
        return this.commonViewContext.getLoggedEvents();
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.commonViewContext.isLoggingEnabled();
    }

    @Override
    public boolean containsKey(String key) {
        return this.commonViewContext.containsKey(key);
    }

    @Override
    public String getMessage(String key, Object ... parameters) {
        return this.commonViewContext.getMessage(key, parameters);
    }

    @Override
    public String getName() {
        return this.commonViewContext.getName();
    }

    @Override
    public void addMessageSource(String messageSource) {
        this.commonViewContext.addMessageSource(messageSource);
    }

    @Override
    public ViewLocatorResolverRegistry getLocatorResolverRegistry() {
        return this.commonViewContext.getLocatorResolverRegistry();
    }

    protected void initializeLocatorHandlerRegistry(ViewLocatorResolverRegistry handlerRegistry) {
    }

    @Override
    public boolean isSimpleOrEmbeddedMode() {
        return this.commonViewContext.isSimpleOrEmbeddedMode();
    }
}

