/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;

public class ActionContext {
    private Experiment experimentOrNull;
    private Project projectOrNull;
    private String spaceCodeOrNull;
    private SampleType sampleTypeOrNull;
    private ExperimentType experimentTypeOrNull;
    private Sample parent;

    public ActionContext() {
    }

    public ActionContext(Experiment experiment) {
        this.experimentOrNull = experiment;
        this.projectOrNull = experiment.getProject();
        this.spaceCodeOrNull = this.projectOrNull.getSpace().getCode();
    }

    public Sample getParent() {
        return this.parent;
    }

    public void setParent(Sample parent) {
        this.parent = parent;
    }

    public Experiment tryGetExperiment() {
        return this.experimentOrNull;
    }

    public void setExperiment(Experiment experiment) {
        this.experimentOrNull = experiment;
    }

    public Project tryGetProject() {
        return this.projectOrNull;
    }

    public String tryGetProjectIdentifier() {
        return this.projectOrNull == null ? null : this.projectOrNull.getIdentifier();
    }

    public void setProject(Project project) {
        this.projectOrNull = project;
    }

    public SampleType tryGetSampleType() {
        return this.sampleTypeOrNull;
    }

    public String tryGetSampleTypeCode() {
        return this.sampleTypeOrNull == null || this.sampleTypeOrNull.isAllTypesCode() ? null : this.sampleTypeOrNull.getCode();
    }

    public void setSampleType(SampleType sampleType) {
        this.sampleTypeOrNull = sampleType;
    }

    public ExperimentType tryGetExperimentType() {
        return this.experimentTypeOrNull;
    }

    public String tryGetExperimentTypeCode() {
        return this.experimentTypeOrNull == null || this.experimentTypeOrNull.isAllTypesCode() ? null : this.experimentTypeOrNull.getCode();
    }

    public void setExperimentType(ExperimentType experimentType) {
        this.experimentTypeOrNull = experimentType;
    }

    public String tryGetSpaceCode() {
        return this.spaceCodeOrNull;
    }

    public void setSpaceCode(String spaceCode) {
        this.spaceCodeOrNull = spaceCode;
    }
}

