/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.IClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientService;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.CommonViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.GenericViewModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IGenericImageBundle;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IPageController;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.UrlParamsHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AppController;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AppEvents;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.LoginController;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AttachmentDownloadLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.BrowserLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.CustomImportLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.GlobalSearchLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.HomeLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.MaterialLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.MetaprojectBrowserLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.MetaprojectLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.OpenViewAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.PermlinkEditingLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.PermlinkLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ProjectLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.SampleRegistrationLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.SearchLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocatorResolverRegistry;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.user.action.LoginAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.DefaultClientPluginFactoryProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactoryProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.ModuleInitializationController;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.BasicLoginCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.aggregation.AggregationServiceLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ApplicationInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GenericConstants;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SessionContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.ViewMode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import com.extjs.gxt.ui.client.mvc.Controller;
import com.extjs.gxt.ui.client.mvc.Dispatcher;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import java.util.ArrayList;
import java.util.List;

public class Client
implements EntryPoint,
ValueChangeHandler<String> {
    private static final String LOGGING_PARAM = "log";
    private static final String LOGGING_ON = "true";
    private static final String DEBUGGING_PARAM = "debug";
    private static final String DEBUGGING_ON = "true";
    private IViewContext<ICommonClientServiceAsync> viewContext;
    private final List<Controller> controllers = new ArrayList<Controller>();

    public final IViewContext<ICommonClientServiceAsync> tryToGetViewContext() {
        return this.viewContext;
    }

    private final IViewContext<ICommonClientServiceAsync> createViewContext() {
        ICommonClientServiceAsync service = (ICommonClientServiceAsync)GWT.create(ICommonClientService.class);
        ServiceDefTarget endpoint = (ServiceDefTarget)service;
        endpoint.setServiceEntryPoint(GenericConstants.COMMON_SERVER_NAME);
        IGenericImageBundle imageBundle = (IGenericImageBundle)GWT.create(IGenericImageBundle.class);
        IPageController pageController = new IPageController(){

            @Override
            public final void reload(boolean logout) {
                if (logout) {
                    Window.Location.reload();
                } else {
                    Client.this.onModuleLoad();
                }
            }
        };
        CommonViewContext commonContext = new CommonViewContext(service, imageBundle, pageController, this.isLoggingEnabled(), this.isDebuggingEnabled(), this.getPageTitle());
        commonContext.setClientPluginFactoryProvider(this.createPluginFactoryProvider(commonContext));
        this.initializeLocatorHandlerRegistry(commonContext.getLocatorResolverRegistry(), commonContext);
        return commonContext;
    }

    private String getPageTitle() {
        return Window.getTitle();
    }

    private String tryGetViewMode() {
        return Window.Location.getParameter((String)"viewMode");
    }

    private boolean isLoggingEnabled() {
        return GWTUtils.getParamString() != null && GWTUtils.getParamString().contains("log=true");
    }

    private boolean isDebuggingEnabled() {
        return GWTUtils.getParamString() != null && GWTUtils.getParamString().contains("debug=true");
    }

    protected IClientPluginFactoryProvider createPluginFactoryProvider(IViewContext<ICommonClientServiceAsync> commonContext) {
        return new DefaultClientPluginFactoryProvider(commonContext);
    }

    private final void initializeControllers(Controller openUrlController) {
        this.removeControllers();
        this.addController(new LoginController(this.viewContext));
        this.addController(new AppController((CommonViewContext)this.viewContext));
        this.addController(openUrlController);
    }

    public void removeControllers() {
        Dispatcher dispatcher = Dispatcher.get();
        for (Controller controller : this.controllers) {
            dispatcher.removeController(controller);
        }
        this.controllers.clear();
        ModuleInitializationController.cleanup();
    }

    private void addController(Controller controller) {
        Dispatcher dispatcher = Dispatcher.get();
        dispatcher.addController(controller);
        this.controllers.add(controller);
    }

    public final void onModuleLoad() {
        this.onModuleLoad(WindowUtils.createOpenUrlController());
    }

    public final void onModuleLoad(Controller openUrlController) {
        if (this.viewContext == null) {
            this.viewContext = this.createViewContext();
            this.initializeControllers(openUrlController);
        }
        History.addValueChangeHandler((ValueChangeHandler)this);
        final IClientServiceAsync service = this.getServiceForRetrievingApplicationInfo(this.viewContext);
        service.getApplicationInfo((AsyncCallback<ApplicationInfo>)new AbstractAsyncCallback<ApplicationInfo>(this.viewContext){

            @Override
            public final void process(ApplicationInfo info) {
                ViewMode viewMode = this.findViewMode(info);
                CommonViewContext.ClientStaticState.setViewMode(viewMode);
                GenericViewModel model = this.viewContext.getModel();
                model.setApplicationInfo(info);
                model.setViewMode(viewMode);
                boolean anonymous = this.isAnonymousLogin(info);
                model.setAnonymousAllowed(anonymous);
                OpenViewAction action = UrlParamsHelper.createNavigateToCurrentUrlAction(this.viewContext);
                SessionContextCallback sessionContextCallback = new SessionContextCallback((CommonViewContext)this.viewContext, action);
                String sessionId = action.getViewLocator().getSessionId();
                service.tryToGetCurrentSessionContext(anonymous, sessionId, sessionContextCallback);
            }

            private ViewMode findViewMode(ApplicationInfo info) {
                ViewMode userViewModeOrNull = this.tryGetUrlViewMode();
                ViewMode viewMode = userViewModeOrNull != null ? userViewModeOrNull : info.getWebClientConfiguration().getDefaultViewMode();
                this.viewContext.log("viewMode = " + (Object)((Object)viewMode));
                return viewMode;
            }

            private boolean isAnonymousLogin(ApplicationInfo info) {
                String anonymousOrNull = Window.Location.getParameter((String)"anonymous");
                if (anonymousOrNull != null) {
                    return anonymousOrNull.equalsIgnoreCase("yes") || anonymousOrNull.equalsIgnoreCase("true");
                }
                return info.getWebClientConfiguration().isDefaultAnonymousLogin();
            }

            private ViewMode tryGetUrlViewMode() {
                String userViewMode = Client.this.tryGetViewMode();
                if (userViewMode != null) {
                    try {
                        return ViewMode.valueOf(userViewMode.toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    protected IClientServiceAsync getServiceForRetrievingApplicationInfo(IViewContext<ICommonClientServiceAsync> context) {
        return context.getService();
    }

    public final void onModuleLoadTest() {
        Controller openUrlController = WindowUtils.createOpenUrlController();
        if (this.viewContext == null) {
            this.viewContext = this.createViewContext();
            this.initializeControllers(openUrlController);
        }
        ICommonClientServiceAsync service = this.viewContext.getService();
        service.getApplicationInfo((AsyncCallback<ApplicationInfo>)new AbstractAsyncCallback<ApplicationInfo>(this.viewContext){

            @Override
            public final void process(ApplicationInfo info) {
                this.viewContext.getModel().setApplicationInfo(info);
                Dispatcher dispatcher = Dispatcher.get();
                dispatcher.dispatch(AppEvents.LOGIN);
            }
        });
    }

    protected void initializeLocatorHandlerRegistry(ViewLocatorResolverRegistry handlerRegistry, IViewContext<ICommonClientServiceAsync> context) {
        handlerRegistry.registerHandler(new MaterialLocatorResolver(context));
        handlerRegistry.registerHandler(new ProjectLocatorResolver(context));
        handlerRegistry.registerHandler(new MetaprojectLocatorResolver(context));
        handlerRegistry.registerHandler(new AttachmentDownloadLocatorResolver(context));
        handlerRegistry.registerHandler(new PermlinkEditingLocatorResolver(context));
        handlerRegistry.registerHandler(new PermlinkLocatorResolver(context));
        handlerRegistry.registerHandler(new SearchLocatorResolver(context));
        handlerRegistry.registerHandler(new MetaprojectBrowserLocatorResolver(context));
        handlerRegistry.registerHandler(new BrowserLocatorResolver(context));
        handlerRegistry.registerHandler(new GlobalSearchLocatorResolver(context));
        handlerRegistry.registerHandler(new HomeLocatorResolver(context));
        handlerRegistry.registerHandler(new SampleRegistrationLocatorResolver(context));
        handlerRegistry.registerHandler(new AggregationServiceLocatorResolver(context));
        handlerRegistry.registerHandler(new CustomImportLocatorResolver(context));
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        UrlParamsHelper.createNavigateToCurrentUrlAction(this.viewContext).execute();
    }

    private static final class SessionContextCallback
    extends AbstractAsyncCallback<SessionContext> {
        private final IDelegatedAction afterInitAction;

        SessionContextCallback(CommonViewContext viewContext, IDelegatedAction afterInitAction) {
            super(viewContext);
            this.afterInitAction = afterInitAction;
        }

        @Override
        public final void process(SessionContext sessionContext) {
            Dispatcher dispatcher = Dispatcher.get();
            if (sessionContext == null) {
                if (this.viewContext.getModel().isAnonymousAllowed()) {
                    this.viewContext.getService().tryToLoginAnonymously(new BasicLoginCallback(this.viewContext.getCommonViewContext(), null){

                        @Override
                        protected void handleMissingSession() {
                            new LoginAction(this.viewContext).execute();
                        }
                    });
                } else {
                    dispatcher.dispatch(AppEvents.LOGIN);
                }
            } else {
                String lastHistoryOrNull;
                this.viewContext.getModel().setSessionContext(sessionContext);
                this.viewContext.initDisplaySettingsManager();
                dispatcher.dispatch(AppEvents.INIT);
                if (!this.viewContext.isSimpleOrEmbeddedMode()) {
                    GWTUtils.setConfirmExitMessage();
                }
                if ((lastHistoryOrNull = this.tryGetLastHistoryToken()) != null) {
                    ViewLocator lastHistoryLocator = new ViewLocator(lastHistoryOrNull);
                    this.viewContext.getLocatorResolverRegistry().locatorExists(lastHistoryLocator, new AsyncCallback<Void>(){

                        public void onSuccess(Void result) {
                            History.newItem((String)lastHistoryOrNull);
                        }

                        public void onFailure(Throwable reason) {
                            viewContext.getModel().getSessionContext().getDisplaySettings().setLastHistoryTokenOrNull(null);
                            viewContext.getDisplaySettingsManager().storeSettings();
                        }
                    });
                } else {
                    this.afterInitAction.execute();
                }
            }
        }

        private String tryGetLastHistoryToken() {
            if (!this.viewContext.isSimpleOrEmbeddedMode() && StringUtils.isBlank((String)History.getToken())) {
                DisplaySettings displaySettings = this.viewContext.getModel().getSessionContext().getDisplaySettings();
                if (displaySettings.isIgnoreLastHistoryToken()) {
                    return null;
                }
                return displaySettings.getLastHistoryTokenOrNull();
            }
            return null;
        }
    }
}

