/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.GlobalSearchTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.SearchableEntitySelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AppEvents;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.EnterKeyListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ButtonWithLoadingMask;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.mvc.Dispatcher;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.TableRowLayout;
import com.google.gwt.user.client.History;

public final class SearchWidget
extends LayoutContainer {
    private static final String PREFIX = "openbis_search-widget_";
    static final String TEXT_FIELD_ID = "openbis_search-widget_text-field";
    static final String CHECKBOX_FIELD_ID = "openbis_search-widget_wildcard-checkbox";
    static final String SUBMIT_BUTTON_ID = "openbis_search-widget_submit-button";
    static final String ENTITY_CHOOSER_ID = "openbis_search-widget_entity-chooser";
    private final SearchableEntitySelectionWidget entityChooser;
    private final TextField<String> textField;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final ButtonWithLoadingMask searchButton;
    private final EnterKeyListener enterKeyListener;

    public SearchWidget(IViewContext<ICommonClientServiceAsync> viewContext) {
        TableRowLayout tableRowLayout = SearchWidget.createLayout();
        this.setLayout((Layout)tableRowLayout);
        this.viewContext = viewContext;
        this.searchButton = this.createSearchButton();
        this.enterKeyListener = new EnterKeyListener(){

            @Override
            protected final void onEnterKey() {
                SearchWidget.this.doSearch();
            }
        };
        this.textField = this.createTextField();
        this.entityChooser = this.createEntityChooser();
        this.add((Component)this.entityChooser);
        this.add((Component)this.textField);
        this.add((Component)this.searchButton);
        Dispatcher.get().addListener(AppEvents.GLOBAL_SEARCH_STARTED_EVENT, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                SearchWidget.this.searchButton.setEnabled(false);
            }
        });
        Dispatcher.get().addListener(AppEvents.GLOBAL_SEARCH_FINISHED_EVENT, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                SearchWidget.this.searchButton.setEnabled(true);
            }
        });
        this.layout();
    }

    private final SearchableEntitySelectionWidget createEntityChooser() {
        SearchableEntitySelectionWidget comboBox = new SearchableEntitySelectionWidget(this.viewContext);
        comboBox.setStyleAttribute("marginRight", "3px");
        comboBox.setId(ENTITY_CHOOSER_ID);
        comboBox.setWidth(150);
        return comboBox;
    }

    private static final TableRowLayout createLayout() {
        TableRowLayout tableRowLayout = new TableRowLayout();
        tableRowLayout.setBorder(0);
        tableRowLayout.setCellPadding(0);
        tableRowLayout.setCellSpacing(0);
        return tableRowLayout;
    }

    private final TextField<String> createTextField() {
        TextField field = new TextField();
        field.setId(TEXT_FIELD_ID);
        field.setWidth(200);
        field.addKeyListener((KeyListener)this.enterKeyListener);
        field.setStyleAttribute("marginRight", "3px");
        return field;
    }

    private final void doSearch() {
        String queryText = (String)this.textField.getValue();
        if (StringUtils.isBlank((String)queryText)) {
            return;
        }
        if (SearchWidget.hasOnlyWildcards(queryText)) {
            GWTUtils.alert(this.viewContext.getMessage("messagebox_warning", new Object[0]), this.viewContext.getMessage("too_generic", queryText));
            return;
        }
        SearchableEntity selectedEntity = this.entityChooser.getSelectedSearchableEntity();
        if (this.viewContext.isSimpleOrEmbeddedMode()) {
            String entityDescription = selectedEntity != null ? selectedEntity.getName() : null;
            String url = SearchWidget.createGlobalSearchLink(entityDescription, queryText, false);
            History.newItem((String)url);
        } else {
            GlobalSearchTabItemFactory.openTabIfEntitiesFound(this.viewContext, selectedEntity, queryText, false);
        }
    }

    private static boolean hasOnlyWildcards(String queryText) {
        boolean onlyWildcard = true;
        for (char c : queryText.toCharArray()) {
            if (c == '*' || c == '?' || c == '|') continue;
            onlyWildcard = false;
            break;
        }
        return onlyWildcard;
    }

    public static String createGlobalSearchLink(String searchableEntity, String queryText, boolean useWildcards) {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", "GLOBAL_SEARCH");
        if (searchableEntity != null) {
            url.addParameter("type", searchableEntity);
        }
        url.addParameter("query", queryText);
        if (useWildcards) {
            url.addParameter("usewildcards", "true");
        }
        return url.toStringWithoutDelimiterPrefix();
    }

    private final ButtonWithLoadingMask createSearchButton() {
        ButtonWithLoadingMask button = new ButtonWithLoadingMask(this.viewContext.getMessage("search_button", new Object[0]), SUBMIT_BUTTON_ID){

            @Override
            public final void doButtonClick() {
                SearchWidget.this.doSearch();
            }
        };
        return button;
    }
}

