/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.framework;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IMainPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AuthorizationGroupGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.CustomImportComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.GeneralImportComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PersonGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.RoleAssignmentGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetBatchUpdatePanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetSearchHitGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetUploadForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.FileFormatTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion.DeletionGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.NewEntityTypeForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentBatchRegistrationPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentBrowserGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentRegistrationPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialBatchRegistrationUpdatePanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialBrowserGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.browser.MetaprojectBrowser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project.ProjectGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project.ProjectRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.PropertyTypeAssignmentForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.PropertyTypeAssignmentGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.PropertyTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.PropertyTypeRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleBatchRegisterUpdatePanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleBrowserGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleRegistrationPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleRegistrationTypeFilter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleSearchHitGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.ScriptGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.ScriptRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary.VocabularyGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary.VocabularyRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.webapp.WebAppComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.webapp.WebAppUrl;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.EntityTypeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.log.LoggingConsole;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebApp;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.Window;

public final class ComponentProvider {
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private IMainPanel mainTabPanelOrNull;

    public ComponentProvider(IViewContext<ICommonClientServiceAsync> viewContext) {
        this.viewContext = viewContext;
    }

    private String getMessage(String key) {
        return this.viewContext.getMessage(key, new Object[0]);
    }

    private ITabItem createTab(String title, IDisposableComponent component) {
        return DefaultTabItem.create(title, component, this.viewContext);
    }

    private ITabItem createRegistrationTab(String title, DatabaseModificationAwareComponent component) {
        return DefaultTabItem.create(title, component, this.viewContext, true);
    }

    private ITabItem createRegistrationTabWithoutCloseConfirmation(String title, DatabaseModificationAwareComponent component) {
        return DefaultTabItem.create(title, component, this.viewContext, false);
    }

    private ITabItem createSimpleTab(String title, Component component, boolean isCloseConfirmationNeeded) {
        return DefaultTabItem.createUnaware(title, component, isCloseConfirmationNeeded, this.viewContext);
    }

    public AbstractTabItemFactory getSampleBrowser(final String initialGroupOrNull, final String initialSampleTypeOrNull) {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent browser = SampleBrowserGrid.create(ComponentProvider.this.viewContext, initialGroupOrNull, initialSampleTypeOrNull);
                return ComponentProvider.this.createTab(this.getTabTitle(), browser);
            }

            @Override
            public String getId() {
                return "openbis_sample-browser_main";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("sample_broser");
            }

            @Override
            public String tryGetLink() {
                return LinkExtractor.createSampleBrowserLink(initialGroupOrNull, initialSampleTypeOrNull);
            }
        };
    }

    public final AbstractTabItemFactory getSampleBrowser() {
        return this.getSampleBrowser(null, null);
    }

    public final AbstractTabItemFactory getMaterialBrowser() {
        return this.getMaterialBrowser(null);
    }

    public final AbstractTabItemFactory getMaterialBrowser(final String initialMaterialTypeOrNull) {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DisposableEntityChooser<TableModelRowWithObject<Material>> browser = MaterialBrowserGrid.createWithTypeChooser(ComponentProvider.this.viewContext, initialMaterialTypeOrNull);
                return ComponentProvider.this.createTab(this.getTabTitle(), browser);
            }

            @Override
            public String getId() {
                return "openbis_material-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.MATERIAL, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("material_browser");
            }

            @Override
            public String tryGetLink() {
                return LinkExtractor.createMaterialBrowserLink(initialMaterialTypeOrNull);
            }
        };
    }

    public final AbstractTabItemFactory getGroupBrowser() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = SpaceGrid.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_space-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.GROUP, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("space_browser");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getScriptBrowser() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DisposableEntityChooser<TableModelRowWithObject<Script>> component = ScriptGrid.create(ComponentProvider.this.viewContext, null, null);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_script-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SCRIPT, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("script_browser");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getAuthorizationGroupBrowser() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = AuthorizationGroupGrid.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_authorization-group-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.AUTHORIZATION_GROUPS, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("authorization_group_browser");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getRoleAssignmentBrowser() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = RoleAssignmentGrid.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_role-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.ROLES, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("role_assignment_browser");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getPersonBrowser() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = PersonGrid.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return PersonGrid.createBrowserId();
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.USERS, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("person_browser");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getSampleRegistration(ActionContext context) {
        return this.getSampleRegistration(context, null);
    }

    public final AbstractTabItemFactory getSampleRegistration(final ActionContext context, final SampleRegistrationTypeFilter filter) {
        AbstractTabItemFactory tab = new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = SampleRegistrationPanel.create(ComponentProvider.this.viewContext, context, filter);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return SampleRegistrationPanel.ID;
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE, HelpPageIdentifier.HelpPageAction.REGISTER);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("sample_registration");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
        tab.setForceReopen(true);
        return tab;
    }

    public final AbstractTabItemFactory getSampleRegistration() {
        return this.getSampleRegistration(new ActionContext());
    }

    public final AbstractTabItemFactory getExperimentRegistration(final ActionContext context) {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = ExperimentRegistrationPanel.create(ComponentProvider.this.viewContext, context);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return ExperimentRegistrationPanel.ID;
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT, HelpPageIdentifier.HelpPageAction.REGISTER);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("experiment_registration");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getExperimentBatchRegistration() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = ExperimentBatchRegistrationPanel.create(ComponentProvider.this.viewContext, false);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return ExperimentBatchRegistrationPanel.getId(false);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT, HelpPageIdentifier.HelpPageAction.IMPORT);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("experiment_import");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getExperimentBatchUpdate() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = ExperimentBatchRegistrationPanel.create(ComponentProvider.this.viewContext, true);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return ExperimentBatchRegistrationPanel.getId(true);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT, HelpPageIdentifier.HelpPageAction.BATCH_UPDATE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("experiment_batch_update");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getExperimentRegistration() {
        return this.getExperimentRegistration(new ActionContext());
    }

    public final AbstractTabItemFactory getSampleBatchRegistration() {
        boolean update = false;
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = SampleBatchRegisterUpdatePanel.create(ComponentProvider.this.viewContext, false);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return SampleBatchRegisterUpdatePanel.getId(false);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE, HelpPageIdentifier.HelpPageAction.IMPORT);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("sample_batch_registration");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getSampleBatchUpdate() {
        boolean update = true;
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = SampleBatchRegisterUpdatePanel.create(ComponentProvider.this.viewContext, true);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return SampleBatchRegisterUpdatePanel.getId(true);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE, HelpPageIdentifier.HelpPageAction.BATCH_UPDATE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("sample_batch_update");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getDataSetBatchUpdate() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = DataSetBatchUpdatePanel.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_data-set-batch-update";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.DATA_SET, HelpPageIdentifier.HelpPageAction.BATCH_UPDATE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("data_set_batch_update");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getMaterialBatchRegistration() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = MaterialBatchRegistrationUpdatePanel.create(ComponentProvider.this.viewContext, false);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return MaterialBatchRegistrationUpdatePanel.getId(false);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.MATERIAL, HelpPageIdentifier.HelpPageAction.IMPORT);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("material_import");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getMaterialBatchUpdate() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = MaterialBatchRegistrationUpdatePanel.create(ComponentProvider.this.viewContext, true);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return MaterialBatchRegistrationUpdatePanel.getId(true);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.MATERIAL, HelpPageIdentifier.HelpPageAction.BATCH_UPDATE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("material_batch_update");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getVocabularyRegistration() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                VocabularyRegistrationForm component = new VocabularyRegistrationForm(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createSimpleTab(this.getTabTitle(), (Component)component, true);
            }

            @Override
            public String getId() {
                return "openbis_vocabulary-registration_form";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.VOCABULARY, HelpPageIdentifier.HelpPageAction.REGISTER);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("vocabulary_registration");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getProjectRegistration() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = ProjectRegistrationForm.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return ProjectRegistrationForm.createId();
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.PROJECT, HelpPageIdentifier.HelpPageAction.REGISTER);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("project_registration");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getScriptRegistration(final EntityKind entityKindOrNull) {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                ScriptRegistrationForm component = ScriptRegistrationForm.create(ComponentProvider.this.viewContext, entityKindOrNull);
                return ComponentProvider.this.createSimpleTab(this.getTabTitle(), (Component)component, true);
            }

            @Override
            public String getId() {
                return ScriptRegistrationForm.createId();
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SCRIPT, HelpPageIdentifier.HelpPageAction.REGISTER);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("script_registration");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getVocabularyBrowser() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = VocabularyGrid.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_vocabulary-browser-grid";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.VOCABULARY, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("vocabulary_browser");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getProjectBrowser() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = ProjectGrid.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_project-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.PROJECT, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("project_browser");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public final AbstractTabItemFactory getMetaprojectBrowser() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                MetaprojectBrowser browser = new MetaprojectBrowser(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), browser);
            }

            @Override
            public String getId() {
                return "openbis_metaproject-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.METAPROJECT, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("metaproject_browser");
            }

            @Override
            public String tryGetLink() {
                return LinkExtractor.createMetaprojectBrowserLink();
            }
        };
    }

    public final AbstractTabItemFactory getDeletionBrowser() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = DeletionGrid.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_deletion-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return HelpPageIdentifier.createSpecific(ComponentProvider.this.getMessage("deletion_browser"));
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("deletion_browser");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getExperimentBrowser(final String initialSpaceOrNull, final String initialProjectOrNull, final String initialExperimentTypeOrNull) {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DisposableEntityChooser<TableModelRowWithObject<Experiment>> browser = ExperimentBrowserGrid.create(ComponentProvider.this.viewContext, initialSpaceOrNull, initialProjectOrNull, initialExperimentTypeOrNull);
                return ComponentProvider.this.createTab(this.getTabTitle(), browser);
            }

            @Override
            public String getId() {
                return "openbis_experiment-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("experiment_browser");
            }

            @Override
            public String tryGetLink() {
                return LinkExtractor.createExperimentBrowserLink(initialSpaceOrNull, initialProjectOrNull, initialExperimentTypeOrNull);
            }
        };
    }

    public AbstractTabItemFactory getExperimentBrowser() {
        return this.getExperimentBrowser(null, null, null);
    }

    public AbstractTabItemFactory getPropertyTypeBrowser() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = PropertyTypeGrid.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_property-type-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.PROPERTY_TYPE, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("property_types");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getPropertyTypeRegistration() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = PropertyTypeRegistrationForm.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_property-type-registration_form";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.PROPERTY_TYPE, HelpPageIdentifier.HelpPageAction.REGISTER);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("property_type_registration");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getPropertyTypeAssignmentBrowser(final EntityType entity, final boolean isEntityTypeEdit) {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = PropertyTypeAssignmentGrid.create(ComponentProvider.this.viewContext, entity, null, isEntityTypeEdit);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                if (entity != null) {
                    return "openbis_property-type-assignment-browser " + entity.getEntityKind().name() + " " + entity.getCode();
                }
                return "openbis_property-type-assignment-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.ASSIGNMENT, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                if (entity != null) {
                    return ComponentProvider.this.getMessage("property_type_assignments") + " " + entity.getEntityKind().name() + " " + entity.getCode();
                }
                return ComponentProvider.this.getMessage("property_type_assignments");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getPropertyTypeExperimentTypeAssignmentForm() {
        return this.getPropertyTypeAssignmentForm(EntityKind.EXPERIMENT, "assign_experiment_property_type");
    }

    public AbstractTabItemFactory getPropertyTypeMaterialTypeAssignmentForm() {
        return this.getPropertyTypeAssignmentForm(EntityKind.MATERIAL, "assign_material_property_type");
    }

    public AbstractTabItemFactory getPropertyTypeDataSetTypeAssignmentForm() {
        return this.getPropertyTypeAssignmentForm(EntityKind.DATA_SET, "assign_data_set_property_type");
    }

    public AbstractTabItemFactory getPropertyTypeSampleTypeAssignmentForm() {
        return this.getPropertyTypeAssignmentForm(EntityKind.SAMPLE, "assign_sample_property_type");
    }

    private AbstractTabItemFactory getPropertyTypeAssignmentForm(final EntityKind entityKind, final String tabTitleMessageKey) {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = PropertyTypeAssignmentForm.create(ComponentProvider.this.viewContext, entityKind);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return PropertyTypeAssignmentForm.createId(entityKind);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.ASSIGNMENT, HelpPageIdentifier.HelpPageAction.REGISTER);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage(tabTitleMessageKey);
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getDataSetSearch() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent browser = DataSetSearchHitGrid.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), browser);
            }

            @Override
            public String getId() {
                return "openbis_data-set-search-hit-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.DATA_SET, HelpPageIdentifier.HelpPageAction.SEARCH);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("data_set_search");
            }

            @Override
            public String tryGetLink() {
                return LinkExtractor.createSearchLink(EntityKind.DATA_SET);
            }
        };
    }

    public AbstractTabItemFactory getSampleSearch() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent browser = SampleSearchHitGrid.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), browser);
            }

            @Override
            public String getId() {
                return "openbis_sample-search-hit-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE, HelpPageIdentifier.HelpPageAction.SEARCH);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("sample_search");
            }

            @Override
            public String tryGetLink() {
                return LinkExtractor.createSearchLink(EntityKind.SAMPLE);
            }
        };
    }

    public AbstractTabItemFactory getSampleTypeBrowser() {
        final ComponentProvider componentProvider = this;
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = SampleTypeGrid.create(ComponentProvider.this.viewContext, componentProvider);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_sample-type-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE_TYPE, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("sample_types");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getMaterialTypeBrowser() {
        final ComponentProvider componentProvider = this;
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = MaterialTypeGrid.create(ComponentProvider.this.viewContext, componentProvider);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_material-type-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.MATERIAL_TYPE, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("material_types");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getNewEntityTypeForm(final EntityKind kind, final EntityType type) {
        final ComponentProvider componentProvider = this;
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = NewEntityTypeForm.create(kind, type, ComponentProvider.this.viewContext, componentProvider);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return NewEntityTypeForm.getTabId(kind, type);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.ADMINISTRATION, HelpPageIdentifier.HelpPageAction.VIEW);
            }

            @Override
            public String getTabTitle() {
                String entityKind = EntityTypeUtils.translatedEntityKindForUI(ComponentProvider.this.viewContext, kind);
                if (type == null) {
                    return "New " + entityKind + " Type";
                }
                return "Edit " + entityKind + " Type " + type.getCode();
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getExperimentTypeBrowser() {
        final ComponentProvider componentProvider = this;
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = ExperimentTypeGrid.create(ComponentProvider.this.viewContext, componentProvider);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_experiment-type-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT_TYPE, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("experiment_types");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getDataSetTypeBrowser() {
        final ComponentProvider componentProvider = this;
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = DataSetTypeGrid.create(ComponentProvider.this.viewContext, componentProvider);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_data-set-type-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.DATA_SET_TYPE, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("data_set_types");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getDataSetUploadTab(final String initialSampleIdentifierOrNull) {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = DataSetUploadForm.create(ComponentProvider.this.viewContext, initialSampleIdentifierOrNull);
                return ComponentProvider.this.createRegistrationTabWithoutCloseConfirmation(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return DataSetUploadForm.createId(initialSampleIdentifierOrNull);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.DATA_SET, HelpPageIdentifier.HelpPageAction.REGISTER);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("data_set_upload");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getFileFormatTypeBrowser() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = FileFormatTypeGrid.create(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createTab(this.getTabTitle(), component);
            }

            @Override
            public String getId() {
                return "openbis_file-format-type-browser";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.FILE_TYPE, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("file_format_types");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory createGeneralImport() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                GeneralImportComponent libraryImportTab = new GeneralImportComponent(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), DatabaseModificationAwareComponent.wrapUnaware((Component)libraryImportTab));
            }

            @Override
            public String getId() {
                return GeneralImportComponent.createId();
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.GENERAL_IMPORT, HelpPageIdentifier.HelpPageAction.IMPORT);
            }

            @Override
            public String getTabTitle() {
                return GeneralImportComponent.getTabTitle(ComponentProvider.this.viewContext);
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory getCustomImport() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                CustomImportComponent customImportTab = new CustomImportComponent(ComponentProvider.this.viewContext);
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), DatabaseModificationAwareComponent.wrapUnaware((Component)customImportTab));
            }

            @Override
            public String getId() {
                return "openbis_custom-import";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.CUSTOM_IMPORT, HelpPageIdentifier.HelpPageAction.IMPORT);
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("custom_import");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public IMainPanel tryGetMainTabPanel() {
        return this.mainTabPanelOrNull;
    }

    public void setMainPanel(IMainPanel mainTabPanel) {
        this.mainTabPanelOrNull = mainTabPanel;
    }

    public AbstractTabItemFactory getLoggingConsole() {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                return ComponentProvider.this.createSimpleTab(this.getTabTitle(), LoggingConsole.create(ComponentProvider.this.viewContext), false);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.ADMINISTRATION, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getId() {
                return "openbis_LoggingConsole";
            }

            @Override
            public String getTabTitle() {
                return ComponentProvider.this.getMessage("LOGGING_CONSOLE");
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    public AbstractTabItemFactory createWebApp(final WebApp webApp) {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                WebAppUrl url = new WebAppUrl(Window.Location.getProtocol(), Window.Location.getHost(), Window.Location.getPath(), webApp.getCode(), ComponentProvider.this.viewContext.getModel().getSessionContext().getSessionID());
                return ComponentProvider.this.createRegistrationTab(this.getTabTitle(), DatabaseModificationAwareComponent.wrapUnaware((Component)new WebAppComponent(url)));
            }

            @Override
            public String getId() {
                return WebAppComponent.getId(webApp.getCode());
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.WEB_APP, HelpPageIdentifier.HelpPageAction.VIEW);
            }

            @Override
            public String getTabTitle() {
                return webApp.getLabel();
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }
}

