/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.framework;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentWithCloseConfirmationUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IComponentWithRefresh;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.LastHistoryTokenUpdater;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.LastModificationStateUpdater;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.TabTitleUpdater;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Header;

public class DefaultTabItem
implements ITabItem {
    private final TabTitleUpdater titleUpdater;
    private final Component component;
    private final IDelegatedAction disposerActionOrNull;
    private final LastModificationStateUpdater lastModificationStateUpdaterOrNull;
    private final LastHistoryTokenUpdater historyTokenUpdater;
    private final IDelegatedAction updaterOrNull;
    private final boolean isCloseConfirmationNeeded;

    public static ITabItem createUnaware(String title, Component component, boolean isCloseConfirmationNeeded, IViewContext<?> viewContext) {
        return new DefaultTabItem(viewContext, title, component, null, null, null, isCloseConfirmationNeeded);
    }

    public static ITabItem createWithUpdater(String title, Component component, IDelegatedAction updater, IViewContext<?> viewContext) {
        return new DefaultTabItem(viewContext, title, component, updater, null, null, false);
    }

    public static ITabItem createUnaware(ContentPanel component, boolean isCloseConfirmationNeeded, IViewContext<?> viewContext) {
        String title = DefaultTabItem.getTabTitle(component);
        return new DefaultTabItem(viewContext, title, (Component)component, null, null, null, isCloseConfirmationNeeded);
    }

    private static String getTabTitle(ContentPanel contentPanel) {
        Header header = contentPanel.getHeader();
        return header != null ? header.getText() : contentPanel.getId();
    }

    public static ITabItem create(String title, DatabaseModificationAwareComponent component, IViewContext<?> viewContext, boolean isCloseConfirmationNeeded) {
        IDelegatedAction disposer = null;
        IDatabaseModificationObserver modificationObserver = component.getModificationObserver();
        if (modificationObserver instanceof IDisposableComponent) {
            disposer = DefaultTabItem.createDisposer((IDisposableComponent)modificationObserver);
        }
        return DefaultTabItem.create(viewContext, title, (Component)component.get(), null, component, disposer, isCloseConfirmationNeeded);
    }

    public static ITabItem create(String title, IDisposableComponent component, IViewContext<?> viewContext) {
        boolean isCloseConfirmationNeeded = false;
        IDelegatedAction disposer = DefaultTabItem.createDisposer(component);
        return DefaultTabItem.create(viewContext, title, component.getComponent(), null, component, disposer, isCloseConfirmationNeeded);
    }

    private static DefaultTabItem create(IViewContext<?> viewContext, String title, Component component, IDelegatedAction updaterOrNull, IDatabaseModificationObserver modificationObserver, IDelegatedAction disposerActionOrNull, boolean isCloseConfirmationNeeded) {
        LastModificationStateUpdater stateUpdater = new LastModificationStateUpdater(viewContext, modificationObserver);
        return new DefaultTabItem(viewContext, title, component, updaterOrNull, stateUpdater, disposerActionOrNull, isCloseConfirmationNeeded);
    }

    private static IDelegatedAction createDisposer(final IDisposableComponent disposableComponent) {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                disposableComponent.dispose();
            }
        };
    }

    private DefaultTabItem(IViewContext<?> viewContext, String initialTitle, Component component, IDelegatedAction updaterOrNull, LastModificationStateUpdater lastModificationStateUpdaterOrNull, IDelegatedAction disposerActionOrNull, boolean isCloseConfirmationNeeded) {
        assert (initialTitle != null) : "Unspecified title.";
        assert (component != null) : "Unspecified component.";
        this.updaterOrNull = updaterOrNull;
        this.historyTokenUpdater = new LastHistoryTokenUpdater(viewContext);
        this.titleUpdater = new TabTitleUpdater(initialTitle);
        this.component = component;
        this.lastModificationStateUpdaterOrNull = lastModificationStateUpdaterOrNull;
        this.disposerActionOrNull = disposerActionOrNull;
        this.isCloseConfirmationNeeded = isCloseConfirmationNeeded;
    }

    @Override
    public final Component getComponent() {
        return this.component;
    }

    @Override
    public final TabTitleUpdater getTabTitleUpdater() {
        return this.titleUpdater;
    }

    @Override
    public boolean isCloseConfirmationNeeded() {
        if (this.isCloseConfirmationNeeded) {
            return ComponentWithCloseConfirmationUtil.shouldAskForCloseConfirmation(this.component);
        }
        return false;
    }

    @Override
    public void onActivate(String linkOrNull) {
        if (linkOrNull != null) {
            this.historyTokenUpdater.update(linkOrNull);
        }
        if (this.updaterOrNull != null) {
            this.updaterOrNull.execute();
        }
        if (this.lastModificationStateUpdaterOrNull != null) {
            this.lastModificationStateUpdaterOrNull.update();
        }
        GWTUtils.updatePageTitle(this.getTabTitleUpdater().getCurrentTitle());
    }

    @Override
    public void onRefresh(String linkOrNull) {
        if (this.component instanceof IComponentWithRefresh) {
            ((IComponentWithRefresh)this.component).refresh();
        }
    }

    @Override
    public void onClose() {
        if (this.disposerActionOrNull != null) {
            this.disposerActionOrNull.execute();
        }
    }
}

