/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.help;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import java.util.ArrayList;
import java.util.List;

public class HelpPageIdentifier {
    private HelpPageDomain domain;
    private HelpPageAction action;
    private boolean specific;
    private String specificPageTitle;
    private static String PAGE_NAME_KEY_PREFIX = "HELP";
    private static String PAGE_NAME_KEY_SEPARATOR = "__";

    public static HelpPageIdentifier createSpecific(String pageTitle) {
        return new HelpPageIdentifier(pageTitle);
    }

    public HelpPageIdentifier(HelpPageDomain domain, HelpPageAction action) {
        assert (domain != null);
        assert (action != null);
        this.domain = domain;
        this.action = action;
        this.specific = false;
    }

    private HelpPageIdentifier(String pageTitle) {
        this.specific = true;
        this.specificPageTitle = pageTitle;
    }

    private HelpPageDomain getHelpPageDomain() {
        assert (this.domain != null);
        return this.domain;
    }

    private HelpPageAction getHelpPageAction() {
        assert (this.action != null);
        return this.action;
    }

    public boolean isSpecific() {
        return this.specific;
    }

    public String getHelpPageTitle(IMessageProvider messageProvider) {
        if (this.specific) {
            return this.specificPageTitle;
        }
        String messageKey = this.getHelpPageTitleKey();
        return messageProvider.containsKey(messageKey) ? messageProvider.getMessage(messageKey, new Object[0]) : messageKey;
    }

    @Deprecated
    public String getHelpPageTitleKey() {
        StringBuilder messageKeyBuilder = new StringBuilder();
        messageKeyBuilder.append(PAGE_NAME_KEY_PREFIX);
        messageKeyBuilder.append(PAGE_NAME_KEY_SEPARATOR);
        List<HelpPageDomain> domainPath = this.getHelpPageDomain().getDomainPath();
        for (HelpPageDomain d : domainPath) {
            messageKeyBuilder.append(d.name() + PAGE_NAME_KEY_SEPARATOR);
        }
        messageKeyBuilder.append(this.getHelpPageAction().name());
        return messageKeyBuilder.toString();
    }

    public static enum HelpPageAction {
        BROWSE,
        VIEW,
        REGISTER,
        IMPORT,
        EDIT,
        DELETE,
        BATCH_UPDATE,
        REPORT,
        SEARCH,
        ACTION;

    }

    public static enum HelpPageDomain {
        EXPERIMENT,
        SAMPLE,
        DATA_SET,
        MATERIAL,
        ADMINISTRATION,
        SEARCH,
        WEB_APP,
        EXPERIMENT_TYPE(EXPERIMENT),
        SAMPLE_TYPE(SAMPLE),
        DATA_SET_TYPE(DATA_SET),
        MATERIAL_TYPE(MATERIAL),
        GROUP(ADMINISTRATION),
        SCRIPT(ADMINISTRATION),
        PROJECT(ADMINISTRATION),
        METAPROJECT(ADMINISTRATION),
        VOCABULARY(ADMINISTRATION),
        TERM(VOCABULARY),
        PROPERTY_TYPE(ADMINISTRATION),
        ASSIGNMENT(PROPERTY_TYPE),
        FILE_TYPE(ADMINISTRATION),
        AUTHORIZATION(ADMINISTRATION),
        GENERAL_IMPORT(ADMINISTRATION),
        CUSTOM_IMPORT(ADMINISTRATION),
        USERS(AUTHORIZATION),
        ROLES(AUTHORIZATION),
        AUTHORIZATION_GROUPS(AUTHORIZATION),
        RELATED_DATA_SETS,
        ATTACHMENTS,
        CHANGE_USER_SETTINGS,
        PERFORM_COMPUTATION,
        EXPORT_DATA,
        TABLE_SETTINGS,
        CUSTOM_COLUMN(TABLE_SETTINGS),
        CUSTOM_FILTER(TABLE_SETTINGS);

        private HelpPageDomain superDomainOrNull;

        private HelpPageDomain() {
        }

        private HelpPageDomain(HelpPageDomain superDomain) {
            this.superDomainOrNull = superDomain;
        }

        public HelpPageDomain getSuperDomainOrNull() {
            return this.superDomainOrNull;
        }

        public List<HelpPageDomain> getDomainPath() {
            ArrayList<HelpPageDomain> result = new ArrayList<HelpPageDomain>();
            this.fillDomainPath(result);
            return result;
        }

        private void fillDomainPath(List<HelpPageDomain> domainPath) {
            if (this.getSuperDomainOrNull() != null) {
                this.getSuperDomainOrNull().fillDomainPath(domainPath);
            }
            domainPath.add(this);
        }
    }
}

