/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.IViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import com.google.gwt.user.client.rpc.AsyncCallback;

public abstract class AbstractViewLocatorResolver
implements IViewLocatorResolver {
    private final String handledAction;

    public AbstractViewLocatorResolver(String handledAction) {
        assert (handledAction != null);
        this.handledAction = handledAction;
    }

    @Override
    public boolean canHandleLocator(ViewLocator locator) {
        return this.handledAction.equals(locator.tryGetAction());
    }

    @Override
    public void locatorExists(ViewLocator locator, AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    protected static final boolean getMandatoryBooleanParameter(ViewLocator locator, String paramName) {
        String value = AbstractViewLocatorResolver.getMandatoryParameter(locator, paramName);
        return new Boolean(value);
    }

    protected static final Boolean getOptionalBooleanParameter(ViewLocator locator, String paramName) {
        String value = AbstractViewLocatorResolver.getOptionalParameter(locator, paramName);
        if (value == null) {
            return null;
        }
        return new Boolean(value);
    }

    protected static final boolean getOptionalBooleanParameter(ViewLocator locator, String paramName, boolean defaultValue) {
        Boolean valueOrNull = AbstractViewLocatorResolver.getOptionalBooleanParameter(locator, paramName);
        if (valueOrNull == null) {
            return defaultValue;
        }
        return valueOrNull;
    }

    protected static final String getMandatoryParameter(ViewLocator locator, String paramName) {
        String valueOrNull = AbstractViewLocatorResolver.getOptionalParameter(locator, paramName);
        if (valueOrNull == null) {
            throw AbstractViewLocatorResolver.createMissingParamException(paramName);
        }
        return valueOrNull;
    }

    protected static final String getOptionalParameter(ViewLocator locator, String paramName) {
        String valueOrNull = locator.getParameters().get(paramName);
        return valueOrNull;
    }

    protected static final void checkRequiredParameter(String valueOrNull, String paramName) throws UserFailureException {
        if (valueOrNull == null) {
            throw AbstractViewLocatorResolver.createMissingParamException(paramName);
        }
    }

    private static UserFailureException createMissingParamException(String paramName) {
        return new UserFailureException("Missing URL parameter: " + paramName);
    }

    protected static final EntityKind getEntityKind(ViewLocator locator) {
        String entityKindValueOrNull = locator.tryGetEntity();
        AbstractViewLocatorResolver.checkRequiredParameter(entityKindValueOrNull, "entity");
        return AbstractViewLocatorResolver.getEntityKind(entityKindValueOrNull);
    }

    protected static final EntityKind getEntityKind(String entityKindValueOrNull) {
        try {
            return EntityKind.valueOf((String)entityKindValueOrNull);
        }
        catch (IllegalArgumentException exception) {
            throw new UserFailureException("Invalid 'entity' URL parameter value.");
        }
    }

    protected class LocatorExistsCallback<T>
    implements AsyncCallback<T> {
        private AsyncCallback<Void> callback;

        public LocatorExistsCallback(AsyncCallback<Void> callback) {
            this.callback = callback;
        }

        public final void onSuccess(T result) {
            if (result != null) {
                this.callback.onSuccess(null);
            } else {
                this.callback.onFailure(null);
            }
        }

        public final void onFailure(Throwable caught) {
            this.callback.onFailure(null);
        }
    }
}

