/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.GlobalSearchTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;

public class GlobalSearchLocatorResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    public static final String GLOBAL_SEARCH_ACTION = "GLOBAL_SEARCH";
    public static final String ENTITY_PARAMETER_KEY = "type";
    public static final String QUERY_PARAMETER_KEY = "query";
    public static final String USE_WILDCARDS_PARAMETER_KEY = "usewildcards";

    public GlobalSearchLocatorResolver(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(GLOBAL_SEARCH_ACTION);
        this.viewContext = viewContext;
    }

    @Override
    public void resolve(ViewLocator locator) throws UserFailureException {
        SearchableEntity selectedSearchableEntity = this.getSearchableEntity(locator);
        String queryText = GlobalSearchLocatorResolver.getMandatoryParameter(locator, QUERY_PARAMETER_KEY);
        String useWildcards = GlobalSearchLocatorResolver.getOptionalParameter(locator, USE_WILDCARDS_PARAMETER_KEY);
        GlobalSearchTabItemFactory.openTab(this.viewContext, selectedSearchableEntity, queryText, useWildcards.equals("true"));
    }

    private SearchableEntity getSearchableEntity(ViewLocator locator) {
        SearchableEntity result = null;
        String entity = GlobalSearchLocatorResolver.getOptionalParameter(locator, ENTITY_PARAMETER_KEY);
        if (entity != null) {
            result = new SearchableEntity();
            result.setName(entity);
            return result;
        }
        return null;
    }
}

