/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.MaterialCodeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class MaterialLocatorResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public MaterialLocatorResolver(IViewContext<ICommonClientServiceAsync> viewContext) {
        super("VIEW");
        this.viewContext = viewContext;
    }

    @Override
    public boolean canHandleLocator(ViewLocator locator) {
        String entityKindValueOrNull = locator.tryGetEntity();
        return super.canHandleLocator(locator) && EntityKind.MATERIAL.name().equals(entityKindValueOrNull);
    }

    @Override
    public void locatorExists(ViewLocator locator, AsyncCallback<Void> callback) {
        try {
            MaterialIdentifier identifier = this.extractMaterialIdentifier(locator);
            this.viewContext.getCommonService().getMaterialInformationHolder(identifier, new AbstractViewLocatorResolver.LocatorExistsCallback<IEntityInformationHolderWithPermId>(this, callback));
        }
        catch (UserFailureException e) {
            callback.onFailure(null);
        }
    }

    @Override
    public void resolve(ViewLocator locator) throws UserFailureException {
        assert (EntityKind.MATERIAL.name().equals(locator.tryGetEntity()));
        this.openInitialMaterialViewer(this.extractMaterialIdentifier(locator));
    }

    protected MaterialIdentifier extractMaterialIdentifier(ViewLocator locator) {
        String codeValueOrNull = locator.getParameters().get("code");
        String materialTypeValueOrNull = locator.getParameters().get("type");
        MaterialLocatorResolver.checkRequiredParameter(codeValueOrNull, "code");
        MaterialLocatorResolver.checkRequiredParameter(materialTypeValueOrNull, "type");
        String decodedMaterialCode = MaterialCodeUtils.decode(codeValueOrNull);
        return new MaterialIdentifier(decodedMaterialCode, materialTypeValueOrNull);
    }

    protected void openInitialMaterialViewer(MaterialIdentifier identifier) throws UserFailureException {
        OpenEntityDetailsTabHelper.open(this.viewContext, identifier, false);
    }
}

