/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectIdentifier;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class MetaprojectLocatorResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public MetaprojectLocatorResolver(IViewContext<ICommonClientServiceAsync> viewContext) {
        super("VIEW");
        this.viewContext = viewContext;
    }

    @Override
    public boolean canHandleLocator(ViewLocator locator) {
        String entityKindValueOrNull = locator.tryGetEntity();
        return super.canHandleLocator(locator) && "METAPROJECT".equals(entityKindValueOrNull);
    }

    @Override
    public void locatorExists(ViewLocator locator, AsyncCallback<Void> callback) {
        try {
            MetaprojectIdentifier identifier = this.extractMetaprojectIdentifier(locator);
            this.viewContext.getService().getMetaproject(identifier.format(), new AbstractViewLocatorResolver.LocatorExistsCallback<Metaproject>(this, callback));
        }
        catch (UserFailureException e) {
            callback.onFailure(null);
        }
    }

    @Override
    public void resolve(ViewLocator locator) throws UserFailureException {
        MetaprojectIdentifier identifier = this.extractMetaprojectIdentifier(locator);
        this.viewContext.getService().getMetaproject(identifier.format(), (AsyncCallback<Metaproject>)new OpenMetaprojectDetailsTabCallback((IViewContext)this.viewContext));
    }

    private MetaprojectIdentifier extractMetaprojectIdentifier(ViewLocator locator) {
        String owner = this.viewContext.getModel().getLoggedInPerson().getUserId();
        String name = MetaprojectLocatorResolver.getMandatoryParameter(locator, "name");
        return new MetaprojectIdentifier(owner, name);
    }

    private static class OpenMetaprojectDetailsTabCallback
    extends AbstractAsyncCallback<Metaproject> {
        private OpenMetaprojectDetailsTabCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(Metaproject result) {
            OpenEntityDetailsTabHelper.openMetaproject(this.viewContext, (IIdAndCodeHolder)result, false);
        }
    }
}

