/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.HashMap;
import java.util.Map;

public class PermlinkLocatorResolver
extends AbstractViewLocatorResolver {
    protected final IViewContext<ICommonClientServiceAsync> viewContext;

    public PermlinkLocatorResolver(IViewContext<ICommonClientServiceAsync> viewContext) {
        this("VIEW", viewContext);
    }

    protected PermlinkLocatorResolver(String action, IViewContext<ICommonClientServiceAsync> viewContext) {
        super(action);
        this.viewContext = viewContext;
    }

    @Override
    public void locatorExists(ViewLocator locator, AsyncCallback<Void> callback) {
        EntityKind entityKindValueOrNull = this.tryGetEntityKindEnum(locator);
        String permIdValueOrNull = this.tryGetPermId(locator);
        if (entityKindValueOrNull != null && permIdValueOrNull != null) {
            this.viewContext.getCommonService().getEntityInformationHolder(entityKindValueOrNull, permIdValueOrNull, new AbstractViewLocatorResolver.LocatorExistsCallback<IEntityInformationHolderWithPermId>(callback));
            return;
        }
        callback.onFailure(null);
    }

    @Override
    public void resolve(ViewLocator locator) throws UserFailureException {
        String entityKindValueOrNull = this.tryGetEntityKind(locator);
        String permIdValueOrNull = this.tryGetPermId(locator);
        if (null != entityKindValueOrNull || null != permIdValueOrNull) {
            PermlinkLocatorResolver.checkRequiredParameter(entityKindValueOrNull, "entity");
            PermlinkLocatorResolver.checkRequiredParameter(permIdValueOrNull, "permId");
            String subtab = this.parseHistoryToken(locator.getHistoryToken()).get("ui-subtab");
            this.openInitialEntityViewer(entityKindValueOrNull, permIdValueOrNull, subtab);
        }
    }

    private Map<String, String> parseHistoryToken(String token) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String parameter : token.split("&")) {
            String[] keyval = parameter.split("=", 2);
            if (keyval.length != 2) continue;
            map.put(keyval[0], keyval[1]);
        }
        return map;
    }

    protected String tryGetEntityKind(ViewLocator locator) {
        return locator.tryGetEntity();
    }

    protected EntityKind tryGetEntityKindEnum(ViewLocator locator) {
        try {
            return EntityKind.valueOf((String)this.tryGetEntityKind(locator));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected String tryGetPermId(ViewLocator locator) {
        return locator.getParameters().get("permId");
    }

    protected void openInitialEntityViewer(String entityKindValue, String permIdValue) throws UserFailureException {
        this.openInitialEntityViewer(entityKindValue, permIdValue, "");
    }

    protected void openInitialEntityViewer(String entityKindValue, String permIdValue, String subtab) throws UserFailureException {
        EntityKind entityKind = PermlinkLocatorResolver.getEntityKind(entityKindValue);
        OpenEntityDetailsTabHelper.open(this.viewContext, entityKind, permIdValue, false, subtab);
    }
}

