/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class ProjectLocatorResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public ProjectLocatorResolver(IViewContext<ICommonClientServiceAsync> viewContext) {
        super("VIEW");
        this.viewContext = viewContext;
    }

    @Override
    public boolean canHandleLocator(ViewLocator locator) {
        String entityKindValueOrNull = locator.tryGetEntity();
        return super.canHandleLocator(locator) && "PROJECT".equals(entityKindValueOrNull);
    }

    @Override
    public void locatorExists(ViewLocator locator, AsyncCallback<Void> callback) {
        try {
            BasicProjectIdentifier identifier = ProjectLocatorResolver.extractProjectIdentifier(locator);
            this.viewContext.getService().getProjectInfo(identifier, new AbstractViewLocatorResolver.LocatorExistsCallback<Project>(this, callback));
        }
        catch (UserFailureException e) {
            callback.onFailure(null);
        }
    }

    @Override
    public void resolve(ViewLocator locator) throws UserFailureException {
        assert ("PROJECT".equals(locator.tryGetEntity()));
        this.openInitialProjectViewer(ProjectLocatorResolver.extractProjectIdentifier(locator));
    }

    static BasicProjectIdentifier extractProjectIdentifier(ViewLocator locator) {
        String codeValueOrNull = locator.getParameters().get("code");
        String spaceValueOrNull = locator.getParameters().get("space");
        ProjectLocatorResolver.checkRequiredParameter(codeValueOrNull, "code");
        ProjectLocatorResolver.checkRequiredParameter(spaceValueOrNull, "space");
        return new BasicProjectIdentifier(spaceValueOrNull, codeValueOrNull);
    }

    protected void openInitialProjectViewer(BasicProjectIdentifier identifier) throws UserFailureException {
        this.viewContext.getService().getProjectInfo(identifier, (AsyncCallback<Project>)new OpenProjectDetailsTabCallback((IViewContext)this.viewContext));
    }

    private static class OpenProjectDetailsTabCallback
    extends AbstractAsyncCallback<Project> {
        private OpenProjectDetailsTabCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(Project result) {
            String href = LinkExtractor.tryExtract(result);
            OpenEntityDetailsTabHelper.open(this.viewContext, result, false, href);
        }
    }
}

