/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleSearchHitGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListSampleDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetWithEntityTypes;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class SampleSearchLocatorResolver {
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public SampleSearchLocatorResolver(IViewContext<ICommonClientServiceAsync> viewContext) {
        this.viewContext = viewContext;
    }

    public void openEntitySearch(DetailedSearchCriteria searchCriteria, String historyToken) throws UserFailureException {
        ListSampleDisplayCriteria displayCriteria = ListSampleDisplayCriteria.createForSearch();
        displayCriteria.updateSearchCriteria(searchCriteria);
        this.viewContext.getCommonService().listSamples(displayCriteria, new OpenEntitySearchTabCallback(displayCriteria, historyToken));
    }

    private static class OpenEntitySearchGridTabAction
    extends AbstractTabItemFactory {
        private final ListSampleDisplayCriteria displayCriteria;
        private final IViewContext<ICommonClientServiceAsync> viewContext;
        private final String historyToken;

        private OpenEntitySearchGridTabAction(ListSampleDisplayCriteria displayCriteria, IViewContext<ICommonClientServiceAsync> viewContext, String historyToken) {
            this.displayCriteria = displayCriteria;
            this.viewContext = viewContext;
            this.historyToken = historyToken;
        }

        private String getMessage(String key) {
            return this.viewContext.getMessage(key, new Object[0]);
        }

        private ITabItem createTab(String dictionaryMsgKey, IDisposableComponent component) {
            String title = this.getMessage(dictionaryMsgKey);
            return DefaultTabItem.create(title, component, this.viewContext);
        }

        @Override
        public ITabItem create() {
            IDisposableComponent browser = SampleSearchHitGrid.createWithInitialDisplayCriteria(this.viewContext, this.displayCriteria);
            return this.createTab("sample_search", browser);
        }

        @Override
        public String getId() {
            return "openbis_sample-search-hit-browser";
        }

        @Override
        public HelpPageIdentifier getHelpPageIdentifier() {
            return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE, HelpPageIdentifier.HelpPageAction.SEARCH);
        }

        @Override
        public String getTabTitle() {
            return this.getMessage("sample_search");
        }

        @Override
        public String tryGetLink() {
            return this.historyToken;
        }
    }

    private class OpenEntitySearchTabCallback
    implements AsyncCallback<ResultSetWithEntityTypes<Sample>> {
        private final ListSampleDisplayCriteria displayCriteria;
        private final String historyToken;

        private OpenEntitySearchTabCallback(ListSampleDisplayCriteria displayCriteria, String historyToken) {
            this.displayCriteria = displayCriteria;
            this.historyToken = historyToken;
        }

        public final void onFailure(Throwable caught) {
            GWTUtils.alert("Error", caught.getMessage());
        }

        public final void onSuccess(ResultSetWithEntityTypes<Sample> result) {
            switch (result.getResultSet().getTotalLength()) {
                case 0: {
                    GWTUtils.alert("Error", "No " + SampleSearchLocatorResolver.this.viewContext.getMessage("samples", new Object[0]).toLowerCase() + " matching criteria [" + this.displayCriteria.getSearchCriteria().toString() + "] were found.");
                    break;
                }
                case 1: {
                    Sample sample = (Sample)((GridRowModel)result.getResultSet().getList().get(0)).getOriginalObject();
                    OpenEntityDetailsTabAction detailsAction = new OpenEntityDetailsTabAction(sample, SampleSearchLocatorResolver.this.viewContext);
                    detailsAction.execute();
                    break;
                }
                default: {
                    OpenEntitySearchGridTabAction searchAction = new OpenEntitySearchGridTabAction(this.displayCriteria, SampleSearchLocatorResolver.this.viewContext, this.historyToken);
                    DispatcherHelper.dispatchNaviEvent(searchAction);
                }
            }
        }
    }
}

