/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.DataSetSearchLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.SampleSearchLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.EntityTypeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.AttributeSearchFieldKindProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchCriteriaConnection;
import java.util.ArrayList;
import java.util.Map;

public class SearchLocatorResolver
extends AbstractViewLocatorResolver {
    protected static final String DEFAULT_SEARCH_STRING = "*";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    protected static final String MATCH_KEY = "searchmatch";
    protected static final String MATCH_ANY_VALUE = "any";
    protected static final String MATCH_ALL_VALUE = "all";
    protected static final SearchCriteriaConnection DEFAULT_MATCH_CONNECTION = SearchCriteriaConnection.MATCH_ALL;
    protected static final boolean DEFAULT_USE_WILDCARDS = false;

    public SearchLocatorResolver(IViewContext<ICommonClientServiceAsync> viewContext) {
        super("SEARCH");
        this.viewContext = viewContext;
    }

    @Override
    public void resolve(ViewLocator locator) throws UserFailureException {
        EntityKind entityKind = SearchLocatorResolver.getEntityKind(locator);
        DetailedSearchCriteria searchCriteria = new ViewLocatorToDetailedSearchCriteriaConverter(locator, entityKind).getDetailedSearchCriteria();
        if (EntityKind.SAMPLE == entityKind) {
            SampleSearchLocatorResolver resolver = new SampleSearchLocatorResolver(this.viewContext);
            resolver.openEntitySearch(searchCriteria, locator.getHistoryToken());
        } else if (EntityKind.DATA_SET == entityKind) {
            DataSetSearchLocatorResolver resolver = new DataSetSearchLocatorResolver(this.viewContext);
            resolver.openEntitySearch(searchCriteria, locator.getHistoryToken());
        } else {
            String sample = EntityTypeUtils.translatedEntityKindForUI(this.viewContext, EntityKind.SAMPLE).toUpperCase();
            String dataSet = EntityTypeUtils.translatedEntityKindForUI(this.viewContext, EntityKind.DATA_SET).toUpperCase();
            String entity = EntityTypeUtils.translatedEntityKindForUI(this.viewContext, entityKind).toUpperCase();
            throw new UserFailureException("URLs for searching openBIS only support " + sample + " and " + dataSet + " searches. Entity " + entity + " is not supported.");
        }
    }

    protected static class ViewLocatorToDetailedSearchCriteriaConverter {
        private final ViewLocator locator;
        private final EntityKind entityKind;

        protected ViewLocatorToDetailedSearchCriteriaConverter(ViewLocator locator, EntityKind entityKind) {
            this.locator = locator;
            this.entityKind = entityKind;
        }

        protected DetailedSearchCriteria getDetailedSearchCriteria() {
            Map<String, String> parameters = this.locator.getParameters();
            ArrayList<DetailedSearchCriterion> criterionList = new ArrayList<DetailedSearchCriterion>();
            DetailedSearchCriteria searchCriteria = new DetailedSearchCriteria();
            searchCriteria.setConnection(DEFAULT_MATCH_CONNECTION);
            searchCriteria.setUseWildcardSearchMode(false);
            for (String key : parameters.keySet()) {
                String value = parameters.get(key);
                if (key.equals(SearchLocatorResolver.MATCH_KEY)) {
                    if (!value.equalsIgnoreCase(SearchLocatorResolver.MATCH_ANY_VALUE)) continue;
                    searchCriteria.setConnection(SearchCriteriaConnection.MATCH_ANY);
                    continue;
                }
                if (key.startsWith("ui-")) continue;
                DetailedSearchCriterion searchCriterion = this.getSearchCriterionForKeyValueAndEntityKind(key, value);
                criterionList.add(searchCriterion);
            }
            if (criterionList.isEmpty()) {
                DetailedSearchCriterion searchCriterion = new DetailedSearchCriterion(DetailedSearchField.createAttributeField(AttributeSearchFieldKindProvider.getAttributeFieldKind(this.entityKind, "CODE")), SearchLocatorResolver.DEFAULT_SEARCH_STRING);
                criterionList.add(searchCriterion);
            }
            searchCriteria.setCriteria(criterionList);
            return searchCriteria;
        }

        protected DetailedSearchCriterion getSearchCriterionForKeyValueAndEntityKind(String key, String value) {
            DetailedSearchField field;
            try {
                IAttributeSearchFieldKind searchFieldKind = AttributeSearchFieldKindProvider.getAttributeFieldKind(this.entityKind, key.toUpperCase());
                field = DetailedSearchField.createAttributeField(searchFieldKind);
            }
            catch (IllegalArgumentException ex) {
                field = DetailedSearchField.createPropertyField(key.toUpperCase());
            }
            return new DetailedSearchCriterion(field, value);
        }
    }
}

