/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ViewLocator {
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String GWT_PARAMETER = "gwt.codesvr";
    private String sessionIdOrNull;
    private String actionOrNull;
    private String entityOrNull;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final String historyToken;

    public ViewLocator(String historyToken) {
        this.historyToken = historyToken;
        this.initializeFromHistoryToken();
    }

    public String getHistoryToken() {
        return this.historyToken;
    }

    public String getSessionId() {
        return this.sessionIdOrNull;
    }

    public String tryGetAction() {
        return this.actionOrNull;
    }

    public String tryGetEntity() {
        return this.entityOrNull;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean isValid() {
        return this.actionOrNull != null;
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    private void initializeFromHistoryToken() {
        if (StringUtils.isBlank((String)this.historyToken)) {
            return;
        }
        String[] params = this.historyToken.split(PARAMETER_SEPARATOR);
        for (int i = 0; i < params.length; ++i) {
            String paramValue;
            String[] paramPair = params[i].split(KEY_VALUE_SEPARATOR);
            String paramName = paramPair.length > 0 ? paramPair[0] : null;
            String string = paramValue = paramPair.length > 1 ? paramPair[1] : null;
            if (paramValue != null) {
                paramValue = StringEscapeUtils.unescapeHtml(paramValue.replaceAll("%2F", "/"));
            }
            if (GWT_PARAMETER.equals(paramName)) continue;
            if ("sessionID".equalsIgnoreCase(paramName)) {
                this.sessionIdOrNull = paramValue;
                continue;
            }
            if ("action".equalsIgnoreCase(paramName)) {
                this.actionOrNull = paramValue;
                continue;
            }
            if ("entity".equalsIgnoreCase(paramName)) {
                this.entityOrNull = paramValue;
                continue;
            }
            if ("permId".equalsIgnoreCase(paramName)) {
                if (this.actionOrNull == null) {
                    this.actionOrNull = "VIEW";
                }
                this.parameters.put(paramName, paramValue);
                continue;
            }
            this.parameters.put(paramName, paramValue);
        }
        if (this.entityOrNull != null && this.actionOrNull == null) {
            this.actionOrNull = "VIEW";
        }
    }
}

