/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.model;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import java.util.ArrayList;
import java.util.List;

public class AttachmentVersionModel
extends SimplifiedBaseModelData {
    public static final String VERSION = "version";
    public static final String VERSION_FILE_NAME = "versionsFileName";
    public static final String PERMLINK = "permlink";
    private static final long serialVersionUID = 1L;

    public AttachmentVersionModel() {
    }

    private AttachmentVersionModel(Attachment attachament) {
        this.set(VERSION_FILE_NAME, this.createDescription(attachament));
        this.set(VERSION, attachament.getVersion());
        this.set(PERMLINK, attachament.getPermlink());
        this.set("registrator", PersonRenderer.createPersonAnchor(attachament.getRegistrator()));
        this.set("registrationDate", attachament.getRegistrationDate());
        this.set("object", attachament);
    }

    private String createDescription(Attachment att) {
        return att.getFileName() + " (" + att.getVersion() + ")";
    }

    public static final List<AttachmentVersionModel> convert(List<Attachment> attachments) {
        ArrayList<AttachmentVersionModel> result = new ArrayList<AttachmentVersionModel>();
        for (Attachment a : attachments) {
            result.add(new AttachmentVersionModel(a));
        }
        return result;
    }
}

