/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.model;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.renderer.TooltipRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import java.util.ArrayList;
import java.util.List;

public class DataSetTypeModel
extends SimplifiedBaseModelData {
    private static final long serialVersionUID = 1L;

    public DataSetTypeModel(DataSetType dataSetType) {
        this(dataSetType.getCode(), (Object)dataSetType);
        this.set("tooltip", TooltipRenderer.renderAsTooltip(dataSetType.getCode(), dataSetType.getDescription()));
    }

    private DataSetTypeModel(String code, Object object) {
        this.set("code", code);
        this.set("object", object);
    }

    public static final List<DataSetTypeModel> convert(List<DataSetType> dataSetTypes, boolean withAll, boolean withTypesInFile) {
        ArrayList<DataSetTypeModel> result = new ArrayList<DataSetTypeModel>();
        for (DataSetType st : dataSetTypes) {
            result.add(new DataSetTypeModel(st));
        }
        if (withTypesInFile && dataSetTypes.size() > 0) {
            result.add(0, DataSetTypeModel.createTypeInFileModel());
        }
        if (withAll) {
            result.add(0, DataSetTypeModel.createAllTypesModel());
        }
        return result;
    }

    private static DataSetTypeModel createTypeInFileModel() {
        DataSetType typeInFile = new DataSetType();
        typeInFile.setCode("(multiple)");
        return new DataSetTypeModel(typeInFile);
    }

    private static DataSetTypeModel createAllTypesModel() {
        return new DataSetTypeModel("(all)", null);
    }
}

