/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.model;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.renderer.TooltipRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import java.util.ArrayList;
import java.util.List;

public class MaterialTypeModel
extends SimplifiedBaseModelData {
    private static final long serialVersionUID = 1L;

    public MaterialTypeModel(MaterialType type) {
        this(type.getCode(), (Object)type);
        this.set("tooltip", TooltipRenderer.renderAsTooltip(type.getCode(), type.getDescription()));
    }

    private static MaterialTypeModel createNone(String label) {
        return new MaterialTypeModel(label, null);
    }

    private MaterialTypeModel(String code, Object object) {
        this.set("code", code);
        this.set("object", object);
    }

    public static final List<MaterialTypeModel> convertWithAdditionalOption(List<MaterialType> types, String additionalOptionLabel, boolean withTypeInFile) {
        List<MaterialTypeModel> result = MaterialTypeModel.convert(types, withTypeInFile);
        result.add(0, MaterialTypeModel.createNone(additionalOptionLabel));
        return result;
    }

    public static final List<MaterialTypeModel> convert(List<MaterialType> types, boolean withTypeInFile) {
        ArrayList<MaterialTypeModel> result = new ArrayList<MaterialTypeModel>();
        for (MaterialType st : types) {
            result.add(new MaterialTypeModel(st));
        }
        if (withTypeInFile && result.size() > 0) {
            result.add(0, MaterialTypeModel.createTypeInFileModel());
        }
        return result;
    }

    private static MaterialTypeModel createTypeInFileModel() {
        MaterialType typeInFile = new MaterialType();
        typeInFile.setCode("(multiple)");
        return new MaterialTypeModel(typeInFile);
    }
}

