/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import java.util.List;

public class PropertyTypeRenderer {
    public static String getDisplayName(PropertyType propertyType, List<PropertyType> types) {
        boolean useCode = PropertyTypeRenderer.isLabelDuplicated(propertyType, types);
        String property = useCode ? PropertyTypeRenderer.getUniqueName(propertyType) : propertyType.getLabel();
        return property;
    }

    private static String getUniqueName(PropertyType propertyType) {
        return propertyType.getLabel() + " (" + propertyType.getCode() + ")";
    }

    private static boolean isLabelDuplicated(PropertyType propertyType, List<PropertyType> propertyTypes) {
        for (PropertyType prop : propertyTypes) {
            if (prop == propertyType || !prop.getLabel().equals(propertyType.getLabel())) continue;
            return true;
        }
        return false;
    }

    public static final String renderAsTooltip(PropertyType propertyType) {
        return PropertyTypeRenderer.renderAsTooltip(propertyType, null);
    }

    public static final String renderAsTooltip(PropertyType propertyType, String sectionOrNull) {
        String code = propertyType.getCode();
        String label = propertyType.getLabel();
        String description = propertyType.getDescription();
        String result = "";
        if (label == null) {
            result = result + "<b>" + code + "</b>";
        } else {
            result = result + "<b>" + label + "</b>";
            result = result + "<br>code: " + code;
        }
        if (sectionOrNull != null) {
            result = result + "<br>section: <b>" + sectionOrNull + "</b>";
        }
        if (description != null) {
            result = result + "<br><hr>description: <i>" + description + "</i>";
        }
        return result.replace(".", ". ");
    }
}

