/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.IRealNumberRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.MultilineHTML;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RealNumberFormatingParameters;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.google.gwt.i18n.client.NumberFormat;

public final class RealNumberRenderer
implements GridCellRenderer<BaseEntityModel<?>>,
IRealNumberRenderer {
    private static final String EXPONENT_FORMAT = "E000";
    private static final String ZEROS = "000000";
    private static final int MAX_PRECISION = "000000".length();
    private final RealNumberFormatingParameters realNumberFormatingParameters;

    public static String render(String value, RealNumberFormatingParameters realNumberFormatingParameters) {
        return RealNumberRenderer.render(value, realNumberFormatingParameters, true);
    }

    public static String render(String value, RealNumberFormatingParameters realNumberFormatingParameters, boolean withTooltip) {
        if (!realNumberFormatingParameters.isFormatingEnabled() || value.length() == 0) {
            return value;
        }
        int precision = Math.max(0, Math.min(MAX_PRECISION, realNumberFormatingParameters.getPrecision()));
        String format = "0." + ZEROS.substring(0, precision);
        boolean scientific = realNumberFormatingParameters.isScientific();
        if (scientific) {
            format = format + EXPONENT_FORMAT;
        }
        try {
            double doubleValue = Double.parseDouble(value);
            String formattedValue = NumberFormat.getFormat((String)format).format(doubleValue).toLowerCase();
            if (!scientific && doubleValue != 0.0 && Double.parseDouble(formattedValue) == 0.0) {
                formattedValue = NumberFormat.getFormat((String)(format + EXPONENT_FORMAT)).format(doubleValue).toLowerCase();
            }
            if (withTooltip) {
                return MultilineHTML.wrapUpInDivWithTooltip(formattedValue, value);
            }
            return formattedValue;
        }
        catch (NumberFormatException ex) {
            return value;
        }
    }

    public RealNumberRenderer(RealNumberFormatingParameters realNumberFormatingParameters) {
        this.realNumberFormatingParameters = realNumberFormatingParameters;
    }

    @Override
    public String render(float value) {
        return RealNumberRenderer.render("" + value, this.realNumberFormatingParameters, false);
    }

    public Object render(BaseEntityModel<?> model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseEntityModel<?>> store, Grid<BaseEntityModel<?>> grid) {
        Object obj = model.get(property);
        if (obj == null) {
            return "";
        }
        return RealNumberRenderer.render(obj.toString(), this.realNumberFormatingParameters);
    }
}

