/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.customcolumn.core;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.customcolumn.core.CustomColumnJSONClientData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.customcolumn.core.CustomColumnJSONException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.customcolumn.core.CustomColumnMethod;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.customcolumn.core.CustomColumnParam;
import com.google.gwt.json.client.JSONException;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;

public class CustomColumnJSONParser {
    public static final CustomColumnJSONClientData parse(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        try {
            JSONValue value = JSONParser.parseLenient((String)str);
            if (value == null || value.isObject() == null) {
                return null;
            }
            JSONObject object = (JSONObject)value;
            try {
                return new CustomColumnJSONClientData(CustomColumnJSONParser.maybeGetMethod(object), CustomColumnJSONParser.maybeGetParams(object));
            }
            catch (CustomColumnJSONException e) {
                return null;
            }
        }
        catch (JSONException e) {
            return null;
        }
    }

    private static final CustomColumnMethod maybeGetMethod(JSONObject object) throws CustomColumnJSONException {
        if (!object.containsKey(CustomColumnParam.$$__METHOD__$$.name())) {
            throw new CustomColumnJSONException("Custom column method not defined");
        }
        JSONValue methodValue = object.get(CustomColumnParam.$$__METHOD__$$.name());
        if (methodValue == null || methodValue.isNull() != null) {
            return null;
        }
        if (methodValue.isString() == null) {
            throw new CustomColumnJSONException("Custom column method is not a String");
        }
        JSONString methodString = (JSONString)methodValue;
        try {
            return CustomColumnMethod.valueOf(methodString.stringValue());
        }
        catch (IllegalArgumentException e) {
            throw new CustomColumnJSONException("Custom column method: " + methodString.stringValue() + " is unknown");
        }
    }

    private static final JSONObject maybeGetParams(JSONObject object) throws CustomColumnJSONException {
        JSONValue paramsValue = object.get(CustomColumnParam.$$__PARAMS__$$.name());
        if (paramsValue == null || paramsValue.isNull() != null) {
            return null;
        }
        if (paramsValue.isObject() == null) {
            throw new CustomColumnJSONException("Custom column method params are not an Object");
        }
        return (JSONObject)paramsValue;
    }
}

