/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.BasicFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.HtmlMessageElement;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FormEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractBatchRegistrationForm
extends AbstractRegistrationForm {
    private static final String FIELD_LABEL_TEMPLATE = "File";
    private static final int NUMBER_OF_FIELDS = 1;
    protected final String sessionKey;
    protected Field<?> templateField;
    protected final BasicFileFieldManager fileFieldsManager;
    protected final TextField<String> emailField;
    protected final RadioGroup asynchronous;
    protected final IViewContext<ICommonClientServiceAsync> viewContext;

    public AbstractBatchRegistrationForm(IViewContext<ICommonClientServiceAsync> viewContext, String id, String sessionKey) {
        super(viewContext, id);
        this.setResetButtonVisible(true);
        this.sessionKey = sessionKey;
        this.viewContext = viewContext;
        this.setScrollMode(Style.Scroll.AUTO);
        this.asynchronous = this.createAsyncRadio();
        this.emailField = this.createEmailField(viewContext.getModel().getSessionContext().getUser().getUserEmail());
        this.templateField = this.createTemplateField();
        this.fileFieldsManager = new BasicFileFieldManager(sessionKey, 1, FIELD_LABEL_TEMPLATE);
        this.fileFieldsManager.setMandatory();
        this.addUploadFeatures(sessionKey);
    }

    protected abstract void save();

    protected void addSpecificFormFields(FormPanel form) {
    }

    protected final void onRender(Element target, int index) {
        super.onRender(target, index);
        this.addFormFields();
    }

    protected boolean isAsync() {
        return this.isAsync(this.asynchronous);
    }

    private boolean isAsync(RadioGroup group) {
        Radio radio = group.getValue();
        if (radio == null) {
            return false;
        }
        if (radio instanceof RadioAsync) {
            return ((RadioAsync)radio).isAsync();
        }
        return false;
    }

    private RadioGroup createAsyncRadio() {
        RadioAsync radioSync = new RadioAsync(false);
        radioSync.setBoxLabel("Wait for result");
        radioSync.setValue(false);
        RadioAsync radioAsync = new RadioAsync(true);
        radioAsync.setBoxLabel("Run in background (and confirm)");
        radioAsync.setValue(true);
        final RadioGroup radioGroup = new RadioGroup();
        radioGroup.setFieldLabel("Wait for result");
        radioGroup.add((Radio)radioSync);
        radioGroup.add((Radio)radioAsync);
        radioGroup.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                if (AbstractBatchRegistrationForm.this.isAsync(radioGroup)) {
                    AbstractBatchRegistrationForm.this.formPanel.remove((Widget)AbstractBatchRegistrationForm.this.asynchronous);
                    for (FileUploadField attachmentField : AbstractBatchRegistrationForm.this.fileFieldsManager.getFields()) {
                        AbstractBatchRegistrationForm.this.formPanel.remove((Widget)DatabaseModificationAwareField.wrapUnaware(attachmentField).get());
                    }
                    AbstractBatchRegistrationForm.this.addOnlyFormFields(true);
                } else {
                    AbstractBatchRegistrationForm.this.formPanel.remove((Widget)AbstractBatchRegistrationForm.this.emailField);
                }
                AbstractBatchRegistrationForm.this.formPanel.layout();
            }
        });
        return radioGroup;
    }

    private TextField<String> createEmailField(String userEmail) {
        TextField field = new TextField();
        field.setAllowBlank(false);
        field.setFieldLabel("Send confirmation email to");
        FieldUtil.markAsMandatory(field);
        field.setValue((Object)userEmail);
        field.setValidateOnBlur(true);
        field.setRegex("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$");
        field.getMessages().setRegexText("Expected email address format: user@domain.com");
        AbstractImagePrototype infoIcon = AbstractImagePrototype.create((ImageResource)this.viewContext.getImageBundle().getInfoIcon());
        FieldUtil.addInfoIcon(field, "All relevant notifications will be send to this email address", infoIcon.createImage());
        return field;
    }

    protected Field<?> createTemplateField() {
        LabelField result = new LabelField(LinkRenderer.renderAsLink(this.viewContext.getMessage("file_template_label", new Object[0])));
        result.sinkEvents(1);
        result.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                WindowUtils.openWindow(AbstractBatchRegistrationForm.this.createTemplateUrl());
            }
        });
        return result;
    }

    protected String createTemplateUrl() {
        return null;
    }

    @Override
    protected void submitValidForm() {
    }

    @Override
    protected void resetFieldsAfterSave() {
        for (FileUploadField attachmentField : this.fileFieldsManager.getFields()) {
            attachmentField.reset();
        }
        this.updateDirtyCheckAfterSave();
    }

    protected void addOnlyFormFields(boolean forceAddEmailField) {
        this.formPanel.add((Widget)this.asynchronous);
        if (forceAddEmailField || this.isAsync()) {
            this.formPanel.add((Widget)this.emailField);
        }
        if (this.templateField != null) {
            this.formPanel.add((Widget)this.templateField);
        }
        for (FileUploadField attachmentField : this.fileFieldsManager.getFields()) {
            this.formPanel.add((Widget)DatabaseModificationAwareField.wrapUnaware(attachmentField).get());
        }
    }

    private final void addFormFields() {
        this.addSpecificFormFields(this.formPanel);
        this.addOnlyFormFields(false);
        this.formPanel.addListener(Events.BeforeSubmit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent be) {
                AbstractBatchRegistrationForm.this.infoBox.displayProgress(AbstractBatchRegistrationForm.this.messageProvider.getMessage("progress_uploading", new Object[0]));
            }
        });
        this.formPanel.addListener(Events.Submit, new FormPanelListener(this.infoBox){

            @Override
            protected void onSuccessfullUpload() {
                AbstractBatchRegistrationForm.this.infoBox.displayProgress(AbstractBatchRegistrationForm.this.messageProvider.getMessage("progress_processing", new Object[0]));
                AbstractBatchRegistrationForm.this.save();
            }

            @Override
            protected void setUploadEnabled() {
                AbstractBatchRegistrationForm.this.setUploadEnabled(true);
            }
        });
        this.redefineSaveListeners();
    }

    void redefineSaveListeners() {
        this.saveButton.removeAllListeners();
        this.addSaveButtonConfirmationListener();
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (AbstractBatchRegistrationForm.this.formPanel.isValid()) {
                    if (AbstractBatchRegistrationForm.this.fileFieldsManager.filesDefined() > 0) {
                        AbstractBatchRegistrationForm.this.setUploadEnabled(false);
                        AbstractBatchRegistrationForm.this.formPanel.submit();
                    } else {
                        AbstractBatchRegistrationForm.this.save();
                    }
                }
            }
        });
    }

    @Override
    protected void setUploadEnabled(boolean enabled) {
        super.setUploadEnabled(enabled);
        this.infoBoxResetListener.setEnabled(enabled);
    }

    private static class RadioAsync
    extends Radio {
        private boolean async;

        private RadioAsync(boolean async) {
            this.async = async;
        }

        public boolean isAsync() {
            return this.async;
        }
    }

    public final class BatchRegistrationCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<List<BatchRegistrationResult>> {
        public BatchRegistrationCallback(IViewContext<?> viewContext) {
            super(AbstractBatchRegistrationForm.this, viewContext);
        }

        @Override
        protected List<HtmlMessageElement> createSuccessfullRegistrationInfo(List<BatchRegistrationResult> result) {
            StringBuilder builder = new StringBuilder();
            for (BatchRegistrationResult batchRegistrationResult : result) {
                builder.append("<b>" + batchRegistrationResult.getFileName() + "</b>: ");
                builder.append(batchRegistrationResult.getMessage());
                builder.append("<br />");
            }
            return Arrays.asList(new HtmlMessageElement(builder.toString()));
        }
    }
}

