/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ManagedPropertySection;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AppEvents;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModuleInitializationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.BorderLayoutDataFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.ModulesSectionsManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabClickListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityEditorTabClickListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenExperimentBrowserTabClickListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.webapp.WebAppComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.webapp.WebAppSortingAndCodeComparator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.webapp.WebAppUrl;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SectionsPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.EntityTypeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ApplicationInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.DeletionUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithProperties;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityVisit;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebApp;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebAppContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableRowLayout;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractViewer<D extends IEntityInformationHolder>
extends ContentPanel
implements IModuleInitializationObserver {
    public static final String ID_EDIT_SUFFIX = "_edit";
    public static final String ID_DELETE_SUFFIX = "_edit";
    private ToolBar toolBar;
    private final List<Button> toolBarButtons = new ArrayList<Button>();
    private LabelToolItem titleLabel;
    private BreadcrumbContainer breadcrumbContainer;
    protected final IViewContext<?> viewContext;
    protected D originalData;
    private final DeletionButtonsManager deletionButtonsManager = new DeletionButtonsManager();
    protected final ModulesSectionsManager moduleSectionManager = new ModulesSectionsManager();
    protected String displayIdSuffix;

    protected abstract void reloadAllData();

    public AbstractViewer(IViewContext<?> viewContext, String id) {
        this(viewContext, null, id, true);
    }

    public AbstractViewer(IViewContext<?> viewContext, String title, String id, boolean withToolBar) {
        this.viewContext = viewContext;
        this.setId(id);
        this.setHeaderVisible(false);
        if (withToolBar) {
            Button editButton;
            this.toolBar = new ToolBar();
            this.setTopComponent((Component)this.toolBar);
            this.titleLabel = new LabelToolItem(title);
            this.breadcrumbContainer = new BreadcrumbContainer(viewContext);
            this.toolBar.add((Component)this.breadcrumbContainer);
            this.toolBar.add((Component)new FillToolItem());
            if (!viewContext.isSimpleOrEmbeddedMode() && (editButton = this.createEditButton()) != null) {
                this.addToolBarButton(editButton);
            }
        }
        viewContext.getClientPluginFactoryProvider().registerModuleInitializationObserver(this);
    }

    protected abstract String getDeleteButtonLabel();

    protected Button createEditButton() {
        Button result = new Button(this.viewContext.getMessage("edit", new Object[0]));
        result.setId(this.getId() + "_edit");
        result.addListener(Events.Select, (Listener)new Listener<ButtonEvent>(){

            public void handleEvent(ButtonEvent be) {
                AbstractViewer.this.showEntityEditor(be.isShiftKey());
            }
        });
        result.disable();
        return result;
    }

    void updateDeletionButtons() {
    }

    protected Button createDeleteButton(final IDelegatedAction deleteAction) {
        Button result = new Button(this.getDeleteButtonLabel());
        result.setId(this.getId() + "_edit");
        result.addListener(Events.Select, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                deleteAction.execute();
            }
        });
        if (DeletionUtils.isDeleted(this.originalData)) {
            result.setVisible(false);
        } else {
            result.disable();
        }
        this.deletionButtonsManager.setDeleteButton(result);
        return result;
    }

    protected Button createRevertDeletionButton(final IDelegatedAction revertAction) {
        Button result = new Button(this.viewContext.getMessage("button_revert_deletion", new Object[0]));
        result.addListener(Events.Select, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                revertAction.execute();
            }
        });
        if (DeletionUtils.isDeleted(this.originalData)) {
            result.disable();
        } else {
            result.setVisible(false);
        }
        this.deletionButtonsManager.setRevertButton(result);
        return result;
    }

    protected final void addToolBarButton(Button button) {
        this.toolBarButtons.add(button);
        this.toolBar.add((Component)button);
    }

    protected final void updateTitle(String title) {
        this.titleLabel.setLabel(title);
    }

    protected final String getBaseIndexURL() {
        return GWTUtils.getBaseIndexURL();
    }

    protected D getOriginalData() {
        assert (this.originalData != null) : "data is not yet set";
        return this.originalData;
    }

    protected List<D> getOriginalDataAsSingleton() {
        return Collections.singletonList(this.getOriginalData());
    }

    protected void showEntityEditor(boolean inBackground) {
        assert (this.originalData != null) : "data is not yet set";
        this.showEntityEditor((IEntityInformationHolder)this.originalData, inBackground);
    }

    private final void showEntityEditor(IEntityInformationHolder entity, boolean inBackground) {
        OpenEntityEditorTabClickListener.showEntityEditor(this.viewContext, entity, inBackground);
    }

    public static String getTitle(IMessageProvider messageProvider, String entityKindDictKey, ICodeHolder codeProvider) {
        return messageProvider.getMessage("details_title", messageProvider.getMessage(entityKindDictKey, new Object[0]), codeProvider.getCode());
    }

    protected void updateOriginalData(D newData) {
        if (newData instanceof IEntityInformationHolderWithIdentifier) {
            IEntityInformationHolderWithIdentifier entity = (IEntityInformationHolderWithIdentifier)newData;
            EntityVisit entityVisit = new EntityVisit(entity);
            this.viewContext.getDisplaySettingsManager().rememberVisit(entityVisit);
        }
        this.originalData = newData;
        this.displayIdSuffix = newData.getEntityType().getCode();
        this.updateBreadcrumbs();
        this.setToolBarButtonsEnabled(true);
        this.deletionButtonsManager.updateButtonVisibitity();
    }

    protected void fillBreadcrumbWidgets(List<Widget> widgets) {
        widgets.add((Widget)this.titleLabel);
    }

    protected void updateBreadcrumbs() {
        this.updateTitle(this.getOriginalDataDescription());
        this.breadcrumbContainer.removeAll();
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        this.fillBreadcrumbWidgets(widgets);
        for (Widget widget : widgets) {
            this.breadcrumbContainer.addBreadcrumb(widget);
        }
        this.breadcrumbContainer.layout();
        this.syncSize();
        this.titleLabel.removeStyleName("xtb-text");
    }

    public void setupRemovedEntityView() {
        this.removeAll();
        this.updateTitle(this.getOriginalDataDescription() + " <b>does not exist any more</b>");
        this.setToolBarButtonsEnabled(false);
    }

    protected void setToolBarButtonsEnabled(boolean enabled) {
        for (Button button : this.toolBarButtons) {
            button.setEnabled(enabled);
        }
    }

    protected String getOriginalDataDescription() {
        return EntityTypeUtils.translatedEntityKindForUI(this.viewContext, this.originalData.getEntityKind()) + " " + this.originalData.getCode() + " [" + this.originalData.getEntityType().getCode() + "]" + (this.isDeleted() ? " <b>(moved to trash)</b>" : "");
    }

    protected final boolean isDeleted() {
        return DeletionUtils.isDeleted(this.originalData);
    }

    protected static final BorderLayoutData createBorderLayoutData(Style.LayoutRegion region) {
        return BorderLayoutDataFactory.create(region);
    }

    protected final boolean isTrashEnabled() {
        return this.viewContext.getModel().getApplicationInfo().getWebClientConfiguration().getEnableTrash();
    }

    protected final AbstractAsyncCallback<Void> createPermanentDeletionCallback() {
        return new CloseViewerCallback(this.viewContext);
    }

    protected final AbstractAsyncCallback<Void> createDeletionCallback() {
        return new CloseViewerCallback((IViewContext)this.viewContext){

            @Override
            protected void process(Void result) {
                super.process(result);
                GWTUtils.displayInfo(this.viewContext.getMessage("use_trash_browser", new Object[0]));
            }
        };
    }

    protected final AbstractAsyncCallback<Void> createRevertDeletionCallback() {
        return new RefreshViewerCallback(this.viewContext);
    }

    @Override
    public void notify(List<IModule> modules) {
        this.moduleSectionManager.initialize(modules);
    }

    protected void attachManagedPropertiesSections(SectionsPanel container, IEntityInformationHolderWithProperties entity) {
        boolean sectionsAdded = false;
        for (IEntityProperty property : entity.getProperties()) {
            IManagedProperty managedProperty;
            if (!property.isManaged() || !(property instanceof IManagedProperty) || !(managedProperty = (IManagedProperty)((Object)property)).isOwnTab()) continue;
            TabContent managedSection = this.createManagedPropertySection(property.getPropertyType().getLabel(), entity, managedProperty);
            container.addSection(managedSection);
            sectionsAdded = true;
        }
        if (sectionsAdded) {
            container.layout();
        }
    }

    protected void attachModuleSpecificSections(SectionsPanel container, IEntityInformationHolderWithProperties entity) {
        this.moduleSectionManager.initialize(container, entity);
    }

    protected void attachWebAppsSections(SectionsPanel container, final IEntityInformationHolderWithProperties entity, WebAppContext context) {
        ArrayList<WebApp> webApps = new ArrayList<WebApp>();
        for (final WebApp webApp : this.getApplicationInfo().getWebapps()) {
            if (!webApp.matchesContext(context) || !webApp.matchesEntity(entity.getEntityKind(), entity.getEntityType())) continue;
            webApps.add(webApp);
        }
        Collections.sort(webApps, new WebAppSortingAndCodeComparator());
        for (final WebApp webApp : webApps) {
            DisposableTabContent webAppTab = new DisposableTabContent(webApp.getLabel(), this.viewContext, entity){

                @Override
                protected IDisposableComponent createDisposableContent() {
                    return new IDisposableComponent(){

                        @Override
                        public void update(Set<DatabaseModificationKind> observedModifications) {
                        }

                        @Override
                        public DatabaseModificationKind[] getRelevantModifications() {
                            return new DatabaseModificationKind[0];
                        }

                        @Override
                        public Component getComponent() {
                            WebAppUrl url = new WebAppUrl(Window.Location.getProtocol(), Window.Location.getHost(), Window.Location.getPath(), webApp.getCode(), AbstractViewer.this.getSessionId());
                            url.addEntityKind(entity.getEntityKind());
                            url.addEntityType(entity.getEntityType());
                            url.addEntityIdentifier(entity.getIdentifier());
                            url.addEntityPermId(entity.getPermId());
                            return new WebAppComponent(url);
                        }

                        @Override
                        public void dispose() {
                        }
                    };
                }
            };
            webAppTab.setIds(new IDisplayTypeIDGenerator(){

                @Override
                public String createID(String suffix) {
                    return this.createID() + suffix;
                }

                @Override
                public String createID() {
                    return DisplayTypeIDGenerator.WEBAPP_SECTION.createID() + "_" + webApp.getCode();
                }
            });
            container.addSection(webAppTab);
        }
    }

    protected TabContent createManagedPropertySection(String header, IEntityInformationHolder entity, IManagedProperty managedProperty) {
        IDelegatedAction refreshAction = new IDelegatedAction(){

            @Override
            public void execute() {
                AbstractViewer.this.reloadAllData();
            }
        };
        return new ManagedPropertySection(header, this.viewContext, entity, managedProperty, refreshAction);
    }

    protected Widget createLabel(String label) {
        Html result = new Html(label);
        return result;
    }

    protected Widget createSpaceLink(Space space) {
        String href = LinkExtractor.createExperimentBrowserLink(space.getCode(), null, null);
        OpenExperimentBrowserTabClickListener listener = new OpenExperimentBrowserTabClickListener(this.viewContext, space.getCode(), null, true);
        Widget link = LinkRenderer.getLinkWidget(space.getCode(), listener, href);
        link.setTitle(this.viewContext.getMessage("space", new Object[0]) + " " + space.getCode());
        return link;
    }

    protected Widget createProjectLink(Project project) {
        String href = LinkExtractor.createExperimentBrowserLink(null, project.getIdentifier(), null);
        OpenExperimentBrowserTabClickListener listener = new OpenExperimentBrowserTabClickListener(this.viewContext, null, project.getIdentifier(), true);
        Widget link = LinkRenderer.getLinkWidget(project.getCode(), listener, href);
        link.setTitle(this.viewContext.getMessage("project", new Object[0]) + " " + project.getCode());
        return link;
    }

    protected Widget createEntityLink(IEntityInformationHolderWithPermId entity) {
        String href = LinkExtractor.tryExtract(entity);
        OpenEntityDetailsTabClickListener listener = new OpenEntityDetailsTabClickListener(entity, this.viewContext);
        Widget link = LinkRenderer.getLinkWidget(entity.getCode(), listener, href, DeletionUtils.isDeleted(entity));
        link.setTitle(EntityTypeUtils.translatedEntityKindForUI(this.viewContext, entity.getEntityKind()) + " " + entity.getCode());
        return link;
    }

    protected IViewContext<?> getViewContext() {
        return this.viewContext;
    }

    protected ApplicationInfo getApplicationInfo() {
        return this.getViewContext().getModel().getApplicationInfo();
    }

    protected String getSessionId() {
        return this.getViewContext().getModel().getSessionContext().getSessionID();
    }

    private class DeletionButtonsManager {
        private Button deleteButtonOrNull;
        private Button revertButtonOrNull;

        private DeletionButtonsManager() {
        }

        public void setDeleteButton(Button deleteButton) {
            this.deleteButtonOrNull = deleteButton;
        }

        public void setRevertButton(Button revertButton) {
            this.revertButtonOrNull = revertButton;
        }

        public void updateButtonVisibitity() {
            if (this.deleteButtonOrNull != null) {
                this.deleteButtonOrNull.setVisible(!DeletionUtils.isDeleted(AbstractViewer.this.originalData));
            }
            if (this.revertButtonOrNull != null) {
                this.revertButtonOrNull.setVisible(DeletionUtils.isDeleted(AbstractViewer.this.originalData));
            }
        }
    }

    private static class BreadcrumbContainer
    extends LayoutContainer {
        private final String separator;

        public BreadcrumbContainer(IMessageProvider messageProvider) {
            this.separator = messageProvider.getMessage("breadcrumbs_separator", new Object[0]);
            this.setLayout(BreadcrumbContainer.createLayout());
        }

        private static Layout createLayout() {
            TableRowLayout tableRowLayout = new TableRowLayout();
            tableRowLayout.setBorder(0);
            tableRowLayout.setCellPadding(0);
            tableRowLayout.setCellSpacing(2);
            return tableRowLayout;
        }

        public void addBreadcrumb(Widget widget) {
            if (this.getItemCount() > 0) {
                this.add((Component)new Html(this.separator));
            }
            this.add(widget);
        }
    }

    private class RefreshViewerCallback
    extends AbstractAsyncCallback<Void> {
        public RefreshViewerCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Void result) {
            AbstractViewer.this.reloadAllData();
        }
    }

    private class CloseViewerCallback
    extends AbstractAsyncCallback<Void> {
        public CloseViewerCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Void result) {
            AbstractViewer.this.fireEvent(AppEvents.CloseViewer);
        }
    }
}

