/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SessionContext;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class BasicLoginCallback
extends AbstractAsyncCallback<SessionContext> {
    private static final int TIMER_PERIOD = 1800000;
    private final String warningMessageKey;
    public static final String LOGIN_FAILED_DIALOG_ID = "login_failed_dialog";

    public BasicLoginCallback(IViewContext<ICommonClientServiceAsync> viewContext, String warningMessageKey) {
        super(viewContext);
        this.warningMessageKey = warningMessageKey;
    }

    @Override
    public final void process(SessionContext sessionContext) {
        if (sessionContext == null) {
            this.handleMissingSession();
        } else {
            this.cleanup();
            this.viewContext.getService().setBaseURL(GWTUtils.getBaseIndexURL(), (AsyncCallback<SessionContext>)new AbstractAsyncCallback<SessionContext>(this.viewContext){

                @Override
                protected void process(SessionContext result) {
                }
            });
            this.viewContext.getPageController().reload(false);
            this.keepSessionAlive();
        }
    }

    protected void handleMissingSession() {
        MessageBox.alert((String)this.viewContext.getMessage("messagebox_warning", new Object[0]), (String)this.viewContext.getMessage(this.warningMessageKey, new Object[0]), (Listener)new Listener<MessageBoxEvent>(){

            public void handleEvent(MessageBoxEvent be) {
                BasicLoginCallback.this.viewContext.getPageController().reload(false);
            }
        }).getDialog().setId(LOGIN_FAILED_DIALOG_ID);
    }

    protected void cleanup() {
    }

    private void keepSessionAlive() {
        Timer t = new Timer(){

            public void run() {
                AsyncCallback<String> callback = new AsyncCallback<String>(){

                    public void onSuccess(String reasonOrNull) {
                        if (reasonOrNull != null) {
                            this.cancel();
                            GWTUtils.alert("Session Expiration", reasonOrNull);
                        }
                    }

                    public void onFailure(Throwable caught) {
                        this.cancel();
                        GWTUtils.alert("Server Connection", "Connection to the server is broken.");
                    }
                };
                BasicLoginCallback.this.viewContext.getCommonService().keepSessionAlive(callback);
            }
        };
        t.scheduleRepeating(1800000);
    }
}

