/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractBatchRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImport;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.MultiField;
import com.google.gwt.user.client.Window;

public class CustomImportForm
extends AbstractBatchRegistrationForm {
    private final CustomImport customImport;

    public CustomImportForm(IViewContext<ICommonClientServiceAsync> viewContext, String id, CustomImport customImport) {
        super(viewContext.getCommonViewContext(), id, id + "-" + customImport.getCode());
        this.setResetButtonVisible(true);
        this.setDirtyCheckEnabled(false);
        this.customImport = customImport;
        if (this.isTemplateAvailable()) {
            MultiField multifield = new MultiField("", new Field[]{this.createTemplateLinkField(), this.createEntityWithTemplateField()});
            multifield.setLabelSeparator("");
            this.templateField = multifield;
        }
    }

    @Override
    protected Field<?> createTemplateField() {
        return null;
    }

    @Override
    protected void save() {
        this.viewContext.getCommonService().performCustomImport(this.sessionKey, this.customImport.getCode(), this.isAsync(), (String)this.emailField.getValue(), new AbstractBatchRegistrationForm.BatchRegistrationCallback(this, this.viewContext));
    }

    private boolean isTemplateAvailable() {
        return this.getTemplateEntityKind() != null && this.getTemplateEntityPermId() != null && this.getTemplateAttachmentName() != null;
    }

    private Field<?> createTemplateLinkField() {
        LabelField linkToTemplate = new LabelField(LinkRenderer.renderAsLink(this.viewContext.getMessage("file_template_label", new Object[0])));
        linkToTemplate.sinkEvents(1);
        linkToTemplate.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                CustomImportForm.this.onLinkToTemplateClick();
            }
        });
        return linkToTemplate;
    }

    private Field<?> createEntityWithTemplateField() {
        LabelField linkToEntityWithTemplate = new LabelField(LinkRenderer.renderAsLink(this.viewContext.getMessage("entity_with_file_template_label", new Object[0])));
        linkToEntityWithTemplate.sinkEvents(1);
        linkToEntityWithTemplate.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                CustomImportForm.this.onLinkToEntityWithTemplateClick();
            }
        });
        linkToEntityWithTemplate.addStyleName("entityWithTemplateField");
        return linkToEntityWithTemplate;
    }

    private void onLinkToTemplateClick() {
        if (AttachmentHolderKind.PROJECT.equals(this.getTemplateEntityKind())) {
            ((ICommonClientServiceAsync)this.viewContext.getService()).getProjectInfoByPermId(this.getTemplateEntityPermId(), new LinkToProjectTemplateCallback(this.viewContext));
        } else {
            this.openUrl(PermlinkUtilities.createAttachmentPermlinkURL(GWTUtils.getBaseIndexURL(), this.getTemplateAttachmentName(), null, this.getTemplateEntityKind(), this.getTemplateEntityPermId()));
        }
    }

    private void onLinkToEntityWithTemplateClick() {
        if (AttachmentHolderKind.PROJECT.equals(this.getTemplateEntityKind())) {
            ((ICommonClientServiceAsync)this.viewContext.getService()).getProjectInfoByPermId(this.getTemplateEntityPermId(), new LinkToEntityWithProjectTemplateCallback(this.viewContext));
        } else {
            this.openUrl(PermlinkUtilities.createPermlinkURL(GWTUtils.getBaseIndexURL(), EntityKind.valueOf((String)this.getTemplateEntityKind().name()), this.getTemplateEntityPermId()));
        }
    }

    private AttachmentHolderKind getTemplateEntityKind() {
        String str = this.customImport.getProperty(CustomImport.PropertyNames.TEMPLATE_ENTITY_KIND.getName());
        if (str == null) {
            return null;
        }
        try {
            return AttachmentHolderKind.valueOf(str);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private String getTemplateEntityPermId() {
        return this.customImport.getProperty(CustomImport.PropertyNames.TEMPLATE_ENTITY_PERMID.getName());
    }

    private String getTemplateAttachmentName() {
        return this.customImport.getProperty(CustomImport.PropertyNames.TEMPLATE_ATTACHMENT_NAME.getName());
    }

    @Override
    protected void setUploadEnabled(boolean enabled) {
        super.setUploadEnabled(enabled);
        this.infoBoxResetListener.setEnabled(enabled);
    }

    private void openUrl(String url) {
        Window.open((String)url, (String)"_blank", (String)"");
    }

    private class LinkToEntityWithProjectTemplateCallback
    extends AbstractAsyncCallback<Project> {
        public LinkToEntityWithProjectTemplateCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Project project) {
            CustomImportForm.this.openUrl(PermlinkUtilities.createProjectPermlinkURL(GWTUtils.getBaseIndexURL(), project.getCode(), project.getSpace().getCode()));
        }
    }

    private class LinkToProjectTemplateCallback
    extends AbstractAsyncCallback<Project> {
        public LinkToProjectTemplateCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Project project) {
            CustomImportForm.this.openUrl(PermlinkUtilities.createProjectAttachmentPermlinkURL(GWTUtils.getBaseIndexURL(), CustomImportForm.this.getTemplateAttachmentName(), null, project.getCode(), project.getSpace().getCode()));
        }
    }
}

