/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PersonListDeactivationConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PersonListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.amc.AddPersonDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.amc.AddPersonToAuthorizationGroupDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListPersonsCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PersonGrid
extends TypedTableGrid<Person> {
    private static final String BROWSER_ID = "openbis_person-browser";
    private static final String GRID_SUFFIX = "-grid";
    private static final String ADD_BUTTON_SUFFIX = "_add-button";
    private static final String REMOVE_BUTTON_SUFFIX = "_remove-button";
    private static final String DEACTIVATE_BUTTON_SUFFIX = "_deactivate-button";
    private final AuthorizationGroup authorizationGroupOrNull;

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        PersonGrid grid = new PersonGrid(viewContext, null);
        grid.extendBottomToolbar();
        return grid.asDisposableWithoutToolbar();
    }

    public static IDisposableComponent createForAuthorizationGroup(IViewContext<ICommonClientServiceAsync> viewContext, AuthorizationGroup authorizationGroup) {
        PersonGrid grid = new PersonGrid(viewContext, authorizationGroup);
        grid.extendBottomToolbar();
        return grid.asDisposableWithoutToolbar();
    }

    private PersonGrid(IViewContext<ICommonClientServiceAsync> viewContext, AuthorizationGroup groupOrNull) {
        super(viewContext, PersonGrid.createBrowserId(groupOrNull), true, DisplayTypeIDGenerator.PERSON_BROWSER_GRID);
        this.authorizationGroupOrNull = groupOrNull;
    }

    public static final String createBrowserId() {
        TechId nullTechId = null;
        return PersonGrid.createBrowserId(nullTechId);
    }

    public static final String createBrowserId(AuthorizationGroup group) {
        return PersonGrid.createBrowserId(TechId.create((IIdHolder)group));
    }

    private static final String createBrowserId(TechId id) {
        return BROWSER_ID + (id != null ? "_" + id : "");
    }

    public static final String createRemoveButtonId(AuthorizationGroup group) {
        return PersonGrid.createBrowserId(group) + REMOVE_BUTTON_SUFFIX;
    }

    public static final String createAddButtonId(AuthorizationGroup group) {
        return PersonGrid.createBrowserId(group) + ADD_BUTTON_SUFFIX;
    }

    public static final String createDeactivateButtonId(AuthorizationGroup group) {
        return PersonGrid.createBrowserId(group) + DEACTIVATE_BUTTON_SUFFIX;
    }

    public static final String createGridId(AuthorizationGroup group) {
        return PersonGrid.createBrowserId(group) + GRID_SUFFIX;
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addPersonButton = new Button(this.viewContext.getMessage("button_add", "Person"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                AbstractRegistrationDialog dialog = PersonGrid.this.authorizationGroupOrNull == null ? PersonGrid.this.createAddPersonDialog() : PersonGrid.this.createAddPersonToAuthoriationGroupDialog();
                dialog.show();
            }
        });
        addPersonButton.setId(PersonGrid.createAddButtonId(this.authorizationGroupOrNull));
        this.addButton(addPersonButton);
        if (this.authorizationGroupOrNull != null) {
            Button deleteButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_delete", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(){

                protected Dialog createDialog(List<TableModelRowWithObject<Person>> selected, IBrowserGridActionInvoker invoker) {
                    ArrayList<Person> selectedPersons = new ArrayList<Person>();
                    for (TableModelRowWithObject<Person> row : selected) {
                        selectedPersons.add(row.getObjectOrNull());
                    }
                    return new PersonListDeletionConfirmationDialog(PersonGrid.this.viewContext, selectedPersons, PersonGrid.this.authorizationGroupOrNull, PersonGrid.this.createRefreshCallback(invoker));
                }
            });
            deleteButton.setId(PersonGrid.createRemoveButtonId(this.authorizationGroupOrNull));
            this.addButton(deleteButton);
            this.allowMultipleSelection();
        } else {
            Button deactivateButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_deactivate", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(){

                protected Dialog createDialog(List<TableModelRowWithObject<Person>> selected, IBrowserGridActionInvoker invoker) {
                    ArrayList<Person> selectedPersons = new ArrayList<Person>();
                    for (TableModelRowWithObject<Person> row : selected) {
                        selectedPersons.add(row.getObjectOrNull());
                    }
                    return new PersonListDeactivationConfirmationDialog(PersonGrid.this.viewContext, selectedPersons, PersonGrid.this.createRefreshCallback(invoker));
                }
            });
            deactivateButton.setId(PersonGrid.createDeactivateButtonId(this.authorizationGroupOrNull));
            this.addButton(deactivateButton);
            this.allowMultipleSelection();
        }
        this.addEntityOperationsSeparator();
    }

    private AddPersonToAuthorizationGroupDialog createAddPersonToAuthoriationGroupDialog() {
        return new AddPersonToAuthorizationGroupDialog(this.viewContext, this.authorizationGroupOrNull, this.createRefreshGridAction());
    }

    private AddPersonDialog createAddPersonDialog() {
        return new AddPersonDialog(this.viewContext, this.createRefreshGridAction());
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Person>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Person>> callback) {
        ListPersonsCriteria criteria = new ListPersonsCriteria(this.authorizationGroupOrNull);
        criteria.copyPagingConfig(resultSetConfig);
        ((ICommonClientServiceAsync)this.viewContext.getService()).listPersons(criteria, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Person>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportPersons(exportCriteria, callback);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("USER_ID");
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<Person>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<Person>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("REGISTRATOR", PersonRenderer.REGISTRATOR_RENDERER);
        return schema;
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected void showEntityViewer(TableModelRowWithObject<Person> person, boolean editMode, boolean inBackground) {
        assert (false) : "not implemented";
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        ArrayList<DatabaseModificationKind> databaseModificationKinds = new ArrayList<DatabaseModificationKind>();
        databaseModificationKinds.add(DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PERSON));
        databaseModificationKinds.add(DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PERSON));
        if (this.authorizationGroupOrNull != null) {
            databaseModificationKinds.add(DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.AUTHORIZATION_GROUP));
        }
        return databaseModificationKinds.toArray(new DatabaseModificationKind[0]);
    }
}

