/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import java.util.ArrayList;
import java.util.List;

public class PersonListDeactivationConfirmationDialog
extends AbstractDataConfirmationDialog<List<Person>> {
    private static final int LABEL_WIDTH = 60;
    private static final int FIELD_WIDTH = 180;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final AbstractAsyncCallback<Void> callback;

    public PersonListDeactivationConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, List<Person> persons, AbstractAsyncCallback<Void> callback) {
        super(viewContext, persons, viewContext.getMessage("deactivate_persons_confirmation_title", new Object[0]));
        this.viewContext = viewContext;
        this.callback = callback;
    }

    private List<String> extractCodes(List<Person> persons) {
        ArrayList<String> result = new ArrayList<String>();
        for (Person p : persons) {
            result.add(p.getUserId());
        }
        return result;
    }

    @Override
    protected String createMessage() {
        List<String> codes = this.extractCodes((List)this.data);
        return this.viewContext.getMessage("deactivate_persons_confirmation_message", codes.size(), StringUtils.abbreviate((String)StringUtils.joinList(codes), (int)1000));
    }

    @Override
    protected void extendForm() {
        this.formPanel.setLabelWidth(60);
        this.formPanel.setFieldWidth(180);
    }

    @Override
    protected void executeConfirmedAction() {
        this.viewContext.getCommonService().deactivatePersons(this.extractCodes((List)this.data), this.callback);
    }
}

