/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.renderer.VocabularyPropertyColRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.DateRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabClickListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.AbstractPropertyValueRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.AbstractSimplePropertyValueRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.IPropertyValueRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ExternalHyperlink;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.MultilineHTML;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.DeletionUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Widget;

public final class PropertyValueRenderers {
    private PropertyValueRenderers() {
    }

    public static final IPropertyValueRenderer<Project> createProjectPropertyValueRenderer(IViewContext<?> viewContext) {
        return new ProjectPropertyValueRenderer(viewContext);
    }

    public static final IPropertyValueRenderer<Sample> createSamplePropertyValueRenderer(IViewContext<?> viewContext, boolean withType) {
        return new SamplePropertyValueRenderer(viewContext, withType);
    }

    public static final IPropertyValueRenderer<Experiment> createExperimentPropertyValueRenderer(IViewContext<?> viewContext) {
        return new EntityInformationHolderPropertyValueRenderer<Experiment>(viewContext);
    }

    public static final IPropertyValueRenderer<AbstractExternalData> createExternalDataPropertyValueRenderer(IViewContext<?> viewContext) {
        return new EntityInformationHolderPropertyValueRenderer<AbstractExternalData>(viewContext);
    }

    public static final IPropertyValueRenderer<SampleType> createSampleTypePropertyValueRenderer(IMessageProvider messageProvider) {
        return new EntityTypePropertyValueRenderer<SampleType>(messageProvider);
    }

    public static final IPropertyValueRenderer<Person> createPersonPropertyValueRenderer(IMessageProvider messageProvider) {
        return new PersonPropertyValueRenderer(messageProvider);
    }

    public static final IPropertyValueRenderer<Deletion> createDeletionPropertyValueRenderer(IMessageProvider messageProvider) {
        return new DeletionPropertyValueRenderer(messageProvider);
    }

    public static final IPropertyValueRenderer<ExperimentType> createExperimentTypePropertyValueRenderer(IMessageProvider messageProvider) {
        return new EntityTypePropertyValueRenderer<ExperimentType>(messageProvider);
    }

    public static final IPropertyValueRenderer<IEntityProperty> createEntityPropertyPropertyValueRenderer(IViewContext<?> viewContext) {
        return new EntityPropertyPropertyValueRenderer(viewContext);
    }

    public static final IPropertyValueRenderer<DataSetType> createDataSetTypePropertyValueRenderer(IMessageProvider messageProvider) {
        return new EntityTypePropertyValueRenderer<DataSetType>(messageProvider);
    }

    public static final IPropertyValueRenderer<MaterialType> createMaterialTypePropertyValueRenderer(IMessageProvider messageProvider) {
        return new EntityTypePropertyValueRenderer<MaterialType>(messageProvider);
    }

    public static final IPropertyValueRenderer<String> createMultilineStringPropertyValueRenderer(IMessageProvider messageProvider) {
        return new MultilineStringPropertyValueRenderer(messageProvider);
    }

    public static IPropertyValueRenderer<DataStore> createDataStorePropertyValueRenderer(IMessageProvider messageProvider) {
        return new DataStorePropertyValueRenderer(messageProvider);
    }

    private static final class DataStorePropertyValueRenderer
    extends AbstractSimplePropertyValueRenderer<DataStore> {
        DataStorePropertyValueRenderer(IMessageProvider messageProvider) {
            super(messageProvider);
        }

        @Override
        public final String renderNotNull(DataStore dataStore) {
            return dataStore.getCode();
        }
    }

    private static final class MultilineStringPropertyValueRenderer
    extends AbstractPropertyValueRenderer<String> {
        public MultilineStringPropertyValueRenderer(IMessageProvider messageProvider) {
            super(messageProvider);
        }

        @Override
        public Widget getAsWidget(String object) {
            return MultilineStringPropertyValueRenderer.createMultilineHtmlWidget(object);
        }

        protected static Widget createMultilineHtmlWidget(String object) {
            return new MultilineHTML(object);
        }
    }

    private static final class SamplePropertyValueRenderer
    extends EntityInformationHolderPropertyValueRenderer<Sample> {
        private final boolean withType;

        SamplePropertyValueRenderer(IViewContext<?> viewContext, boolean withType) {
            super(viewContext);
            this.withType = withType;
        }

        @Override
        public FlowPanel getAsWidget(Sample sample) {
            FlowPanel panel = super.getAsWidget(sample);
            if (this.withType) {
                panel.add((Widget)new InlineHTML(" [" + sample.getSampleType().getCode() + "]"));
            }
            return panel;
        }
    }

    public static class ProjectPropertyValueRenderer
    extends AbstractPropertyValueRenderer<Project> {
        private final IViewContext<?> viewContext;

        public ProjectPropertyValueRenderer(IViewContext<?> viewContext) {
            super(viewContext);
            this.viewContext = viewContext;
        }

        @Override
        public Widget getAsWidget(final Project project) {
            String displayText = project.getIdentifier();
            final String href = LinkExtractor.tryExtract(project);
            ClickHandler listener = new ClickHandler(){

                public void onClick(ClickEvent event) {
                    OpenEntityDetailsTabHelper.open(viewContext, project, WidgetUtils.ifSpecialKeyPressed(event.getNativeEvent()), href);
                }
            };
            Widget link = LinkRenderer.getLinkWidget(displayText, listener, href, false);
            return link;
        }
    }

    public static class EntityInformationHolderPropertyValueRenderer<T extends IEntityInformationHolderWithIdentifier>
    extends AbstractPropertyValueRenderer<T> {
        private final IViewContext<?> viewContext;

        public EntityInformationHolderPropertyValueRenderer(IViewContext<?> viewContext) {
            super(viewContext);
            this.viewContext = viewContext;
        }

        public FlowPanel getAsWidget(T entity) {
            String displayText = this.getDisplayText(entity);
            boolean invalidate = DeletionUtils.isDeleted(entity);
            OpenEntityDetailsTabClickListener listener = new OpenEntityDetailsTabClickListener((IEntityInformationHolderWithPermId)entity, this.viewContext);
            String href = LinkExtractor.tryExtract(entity);
            Widget link = LinkRenderer.getLinkWidget(displayText, listener, href, invalidate);
            FlowPanel panel = new FlowPanel();
            panel.add(link);
            return panel;
        }

        protected String getDisplayText(T entity) {
            return entity.getIdentifier();
        }
    }

    private static final class EntityTypePropertyValueRenderer<T extends EntityType>
    extends AbstractSimplePropertyValueRenderer<T> {
        EntityTypePropertyValueRenderer(IMessageProvider messageProvider) {
            super(messageProvider);
        }

        @Override
        protected final String renderNotNull(T value) {
            return value.getCode();
        }
    }

    private static final class EntityPropertyPropertyValueRenderer
    extends AbstractPropertyValueRenderer<IEntityProperty> {
        private final IViewContext<?> viewContext;

        EntityPropertyPropertyValueRenderer(IViewContext<?> viewContext) {
            super(viewContext);
            this.viewContext = viewContext;
        }

        @Override
        public Widget getAsWidget(IEntityProperty object) {
            String value = object.getValue();
            if (!StringUtils.isBlank((String)value) && StringEscapeUtils.unescapeHtml(value).startsWith(BasicConstant.ERROR_PROPERTY_PREFIX)) {
                String errorMsgText = StringEscapeUtils.unescapeHtml(value).substring(BasicConstant.ERROR_PROPERTY_PREFIX.length());
                return this.createMultilineHtmlWidget(errorMsgText);
            }
            switch (this.getDataTypeCode(object)) {
                case MATERIAL: {
                    return this.createLinkToMaterial(object);
                }
                case CONTROLLEDVOCABULARY: {
                    return this.createVocabularyTermLink(object);
                }
                case HYPERLINK: {
                    return this.createHyperlink(object);
                }
                case MULTILINE_VARCHAR: {
                    return this.createMultilineHtmlWidget(object);
                }
                case XML: {
                    return this.createHtmlWidget(object.tryGetAsString());
                }
            }
            return this.createHtmlWidget(object);
        }

        private DataTypeCode getDataTypeCode(IEntityProperty property) {
            return this.getPropertyType(property).getDataType().getCode();
        }

        private Widget createLinkToMaterial(IEntityProperty object) {
            Material material = object.getMaterial();
            if (material != null) {
                OpenEntityDetailsTabClickListener listener = new OpenEntityDetailsTabClickListener(material, this.viewContext);
                String href = LinkExtractor.tryExtract(material);
                Widget link = LinkRenderer.getLinkWidget(material.getCode(), listener, href);
                FlowPanel panel = new FlowPanel();
                panel.add(link);
                if (this.isAllowedMaterialTypeUnspecified(object)) {
                    panel.add((Widget)new InlineHTML(" [" + material.getMaterialType().getCode() + "]"));
                }
                return panel;
            }
            return this.createHtmlWidget(object);
        }

        private Widget createMultilineHtmlWidget(IEntityProperty object) {
            return this.createMultilineHtmlWidget(object.getValue());
        }

        private Widget createMultilineHtmlWidget(String multilineText) {
            return MultilineStringPropertyValueRenderer.createMultilineHtmlWidget(multilineText);
        }

        private Widget createHtmlWidget(String html) {
            return new InlineHTML(html);
        }

        private Widget createHtmlWidget(IEntityProperty object) {
            return this.createHtmlWidget(object.getValue());
        }

        private Widget createHyperlink(IEntityProperty object) {
            String value = object.getValue();
            return new ExternalHyperlink(value, value);
        }

        private Widget createVocabularyTermLink(IEntityProperty object) {
            VocabularyTerm term = object.getVocabularyTerm();
            String html = "";
            if (term != null) {
                html = VocabularyPropertyColRenderer.renderTerm(term);
            }
            return this.createHtmlWidget(html);
        }

        private boolean isAllowedMaterialTypeUnspecified(IEntityProperty property) {
            return this.getPropertyType(property).getMaterialType() == null;
        }

        private PropertyType getPropertyType(IEntityProperty property) {
            return property.getPropertyType();
        }
    }

    private static final class DeletionPropertyValueRenderer
    extends AbstractSimplePropertyValueRenderer<Deletion> {
        DeletionPropertyValueRenderer(IMessageProvider messageProvider) {
            super(messageProvider);
        }

        private final String rendererPerson(Person person) {
            if (person != null) {
                return PersonRenderer.createPersonAnchor(person);
            }
            return "";
        }

        @Override
        public final String renderNotNull(Deletion deletion) {
            return this.getMessageProvider().getMessage("deletion_template", this.rendererPerson(deletion.getRegistrator()), DateRenderer.renderDate(deletion.getRegistrationDate(), "yyyy-MM-dd HH:mm:ss"), deletion.getReason());
        }
    }

    private static final class PersonPropertyValueRenderer
    extends AbstractSimplePropertyValueRenderer<Person> {
        PersonPropertyValueRenderer(IMessageProvider messageProvider) {
            super(messageProvider);
        }

        @Override
        public final String renderNotNull(Person person) {
            return PersonRenderer.createPersonAnchor(person);
        }
    }
}

