/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.amc.AddGroupDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataListPermanentDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class SpaceGrid
extends TypedTableGrid<Space> {
    public static final String BROWSER_ID = "openbis_space-browser";
    public static final String GRID_ID = "openbis_space-browser-grid";
    public static final String ADD_BUTTON_ID = "openbis_space-browser_add-button";
    public static final String DELETE_BUTTON_ID = "openbis_space-browser_delete-button";
    public static final String EDIT_BUTTON_ID = "openbis_space-browser-edit-button";
    private final IDelegatedAction postRegistrationCallback = this.createRefreshGridAction();

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        SpaceGrid grid = new SpaceGrid(viewContext);
        grid.extendBottomToolbar();
        return grid.asDisposableWithoutToolbar();
    }

    private SpaceGrid(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.SPACES_BROWSER_GRID);
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addGroupButton = new Button(this.viewContext.getMessage("button_add", this.viewContext.getMessage("group", new Object[0])), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                AddGroupDialog dialog = new AddGroupDialog(SpaceGrid.this.viewContext, SpaceGrid.this.createRefreshGridAction());
                dialog.show();
            }
        });
        addGroupButton.setId(ADD_BUTTON_ID);
        this.addButton(addGroupButton);
        Button editButton = this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<Space>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<Space>> selectedItem, boolean keyPressed) {
                Space space = selectedItem.getBaseObject().getObjectOrNull();
                SpaceGrid.this.createEditDialog(space).show();
            }
        });
        editButton.setId(EDIT_BUTTON_ID);
        this.addButton(editButton);
        Button deleteButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_delete", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(){

            protected Dialog createDialog(List<TableModelRowWithObject<Space>> groups, IBrowserGridActionInvoker invoker) {
                return new GroupListDeletionConfirmationDialog(SpaceGrid.this.viewContext, groups, SpaceGrid.this.createRefreshCallback(invoker));
            }
        });
        deleteButton.setId(DELETE_BUTTON_ID);
        this.addButton(deleteButton);
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    private Window createEditDialog(final Space space) {
        String code = space.getCode();
        final String description = space.getDescription();
        String title = this.viewContext.getMessage("edit_title", this.viewContext.getMessage("group", new Object[0]), code);
        return new AbstractRegistrationDialog(this.viewContext, title, this.postRegistrationCallback){
            private final DescriptionField descriptionField;
            {
                super(viewContext, title, postRegistrationCallback);
                boolean mandatory = false;
                this.descriptionField = 4.createDescriptionField(SpaceGrid.this.viewContext, mandatory);
                FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, description);
                this.addField((Widget)this.descriptionField);
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
                space.setDescription((String)this.descriptionField.getValue());
                ((ICommonClientServiceAsync)SpaceGrid.this.viewContext.getService()).updateSpace(space, registrationCallback);
            }
        };
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<Space>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<Space>> definitions = super.createColumnsDefinition();
        definitions.setGridCellRendererFor("REGISTRATOR", PersonRenderer.REGISTRATOR_RENDERER);
        return definitions;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Space>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Space>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listSpaces(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Space>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportSpaces(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SPACE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SPACE)};
    }

    private static final class GroupListDeletionConfirmationDialog
    extends AbstractDataListPermanentDeletionConfirmationDialog<TableModelRowWithObject<Space>> {
        private final IViewContext<ICommonClientServiceAsync> viewContext;

        public GroupListDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, List<TableModelRowWithObject<Space>> data, AbstractAsyncCallback<Void> callback) {
            super(viewContext, data, callback);
            this.viewContext = viewContext;
            this.setId("deletion-confirmation-dialog");
        }

        @Override
        protected void executeDeletion(AsyncCallback<Void> deletionCallback) {
            List d = (List)this.data;
            ArrayList<TechId> list = new ArrayList<TechId>();
            for (TableModelRowWithObject tableModelRowWithObject : d) {
                list.add(new TechId(((Space)tableModelRowWithObject.getObjectOrNull()).getId()));
            }
            this.viewContext.getCommonService().deleteSpaces(list, (String)this.reason.getValue(), deletionCallback);
        }

        @Override
        protected String getEntityName() {
            return this.messageProvider.getMessage("group", new Object[0]);
        }
    }
}

