/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.amc;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ProjectSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.ListBox;
import java.util.ArrayList;
import java.util.List;

public class RoleListBox
extends ListBox {
    private IViewContext<ICommonClientServiceAsync> viewContext;
    private List<RoleWithHierarchy> roles;

    public RoleListBox(IViewContext<ICommonClientServiceAsync> viewContext, final SpaceSelectionWidget groupWidget, final ProjectSelectionWidget projectWidget) {
        this.viewContext = viewContext;
        for (RoleWithHierarchy visibleRoleCode : this.getRoles()) {
            this.addItem(visibleRoleCode.toString());
        }
        this.setVisibleItemCount(1);
        this.updateWidgetsVisibility(groupWidget, projectWidget);
        this.addChangeHandler(new ChangeHandler(){

            public final void onChange(ChangeEvent sender) {
                RoleListBox.this.updateWidgetsVisibility(groupWidget, projectWidget);
            }
        });
    }

    public final RoleWithHierarchy getValue() {
        return this.getRoles().get(this.getSelectedIndex());
    }

    private void updateWidgetsVisibility(SpaceSelectionWidget group, ProjectSelectionWidget project) {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getRoles().size()) {
            return;
        }
        RoleWithHierarchy role = this.getRoles().get(index);
        boolean spaceLevel = role.isSpaceLevel();
        boolean projectLevel = role.isProjectLevel();
        FieldUtil.setMandatoryFlag(group, spaceLevel);
        group.setVisible(spaceLevel);
        FieldUtil.setMandatoryFlag(project, projectLevel);
        project.setVisible(projectLevel);
    }

    private List<RoleWithHierarchy> getRoles() {
        if (this.roles == null) {
            boolean projectLevelAuthorizationEnabled = this.viewContext.getModel().getApplicationInfo().isProjectLevelAuthorizationEnabled();
            this.roles = new ArrayList<RoleWithHierarchy>();
            for (RoleWithHierarchy role : RoleWithHierarchy.values()) {
                if (RoleWithHierarchy.INSTANCE_DISABLED.equals(role) || role.isProjectLevel() && !projectLevelAuthorizationEnabled) continue;
                this.roles.add(role);
            }
        }
        return this.roles;
    }
}

