/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetArchivingMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetUploadConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractEntityGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.GridUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.entity.PropertyTypesCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.entity.PropertyTypesCriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.TextToolItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedDatasetCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.DatasetImageOverviewUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class AbstractExternalDataGrid
extends AbstractEntityGrid<AbstractExternalData> {
    public static final String SHOW_DETAILS_BUTTON_ID_SUFFIX = "_show-details-button";
    private final ICriteriaProvider<PropertyTypesCriteria> criteriaProvider = this.createCriteriaProvider();

    protected AbstractExternalDataGrid(IViewContext<ICommonClientServiceAsync> viewContext, String browserId, String gridId, DisplayTypeIDGenerator displayTypeIDGenerator) {
        super(viewContext, browserId, true, displayTypeIDGenerator);
        this.setId(browserId);
        this.extendBottomToolbar();
        this.linkProject();
    }

    private void linkProject() {
        ICellListenerAndLinkGenerator<AbstractExternalData> listenerAndLinkGenerator = new ICellListenerAndLinkGenerator<AbstractExternalData>(){

            @Override
            public void handle(TableModelRowWithObject<AbstractExternalData> rowItem, boolean specialKeyPressed) {
                Project project = this.tryGetProject(rowItem.getObjectOrNull());
                String href = LinkExtractor.tryExtract(project);
                OpenEntityDetailsTabHelper.open(AbstractExternalDataGrid.this.viewContext, project, specialKeyPressed, href);
            }

            @Override
            public String tryGetLink(AbstractExternalData entity, ISerializableComparable comparableValue) {
                Project project = this.tryGetProject(entity);
                return project == null ? null : LinkExtractor.tryExtract(project);
            }

            private Project tryGetProject(AbstractExternalData dataSet) {
                Experiment experiment = dataSet.getExperiment();
                Sample sample = dataSet.getSample();
                Project project = null;
                if (experiment != null) {
                    project = experiment.getProject();
                } else if (sample != null) {
                    project = sample.getProject();
                }
                return project;
            }
        };
        this.registerListenerAndLinkGenerator("PROJECT", listenerAndLinkGenerator);
        this.registerListenerAndLinkGenerator("PROJECT_IDENTIFIER", listenerAndLinkGenerator);
    }

    @Override
    protected boolean supportsExportForUpdate() {
        return true;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<AbstractExternalData>> callback) {
    }

    protected void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        if (!this.viewContext.isSimpleOrEmbeddedMode()) {
            this.addButton(this.createSelectedItemButton(this.viewContext.getMessage("button_show_details", new Object[0]), this.getId() + SHOW_DETAILS_BUTTON_ID_SUFFIX, this.asShowEntityInvoker(false)));
            this.addButton(this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), this.asShowEntityInvoker(true)));
            this.addTaggingButtons();
            String deleteTitle = this.viewContext.getMessage("button_delete", new Object[0]);
            String deleteAllTitle = deleteTitle + " All";
            Button deleteButton = new Button(deleteAllTitle, (SelectionListener)new TypedTableGrid.AbstractCreateDialogListener(){

                protected Dialog createDialog(List<TableModelRowWithObject<AbstractExternalData>> dataSets, IBrowserGridActionInvoker invoker) {
                    return new DataSetListDeletionConfirmationDialog((IViewContext<ICommonClientServiceAsync>)AbstractExternalDataGrid.this.viewContext, (AsyncCallback<Void>)AbstractExternalDataGrid.this.createRefreshCallback(invoker), AbstractExternalDataGrid.this.getSelectedAndDisplayedItemsAction().execute());
                }
            });
            this.changeButtonTitleOnSelectedItems(deleteButton, deleteAllTitle, deleteTitle);
            this.addButton(deleteButton);
        }
        Button uploadButton = new Button(this.viewContext.getMessage("button_upload_datasets", new Object[0]), (SelectionListener)new TypedTableGrid.AbstractCreateDialogListener(){

            protected Dialog createDialog(List<TableModelRowWithObject<AbstractExternalData>> dataSets, IBrowserGridActionInvoker invoker) {
                return new DataSetUploadConfirmationDialog(dataSets, AbstractExternalDataGrid.this.getSelectedAndDisplayedItemsAction(), AbstractExternalDataGrid.this.getTotalCount(), AbstractExternalDataGrid.this.viewContext);
            }
        });
        if (StringUtils.isBlank((String)this.viewContext.getModel().getApplicationInfo().getCifexURL())) {
            uploadButton.disable();
        }
        this.addButton(uploadButton);
        if (this.viewContext.getModel().getApplicationInfo().isArchivingConfigured() && !this.viewContext.isSimpleOrEmbeddedMode()) {
            this.addButton(this.createArchivingMenu());
        }
        this.addEntityOperationsSeparator();
        this.allowMultipleSelection();
    }

    protected ICriteriaProvider<PropertyTypesCriteria> getCriteriaProvider() {
        return this.criteriaProvider;
    }

    private ICriteriaProvider<PropertyTypesCriteria> createCriteriaProvider() {
        EntityKind entityKind = this.getEntityKindOrNull();
        return new PropertyTypesCriteriaProvider(this.viewContext, entityKind){

            @Override
            public PropertyTypesCriteria tryGetCriteria() {
                PropertyTypesCriteria propertyTypesCriteria = super.tryGetCriteria();
                return propertyTypesCriteria;
            }
        };
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    private final TextToolItem createArchivingMenu() {
        return new DataSetArchivingMenu(this.viewContext, this.getSelectedAndDisplayedItemsAction(), this.createRefreshGridAction());
    }

    public final IDelegatedActionWithResult<SelectedAndDisplayedItems> getSelectedAndDisplayedItemsAction() {
        return new IDelegatedActionWithResult<SelectedAndDisplayedItems>(){

            @Override
            public SelectedAndDisplayedItems execute() {
                return new SelectedAndDisplayedItems(AbstractExternalDataGrid.this.getSelectedBaseObjects(), AbstractExternalDataGrid.this.createTableExportCriteria(), AbstractExternalDataGrid.this.getTotalCount());
            }
        };
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<AbstractExternalData>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<AbstractExternalData>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("REGISTRATOR", PersonRenderer.REGISTRATOR_RENDERER);
        schema.setGridCellRendererFor("MODIFIER", PersonRenderer.MODIFIER_RENDERER);
        schema.setGridCellRendererFor("SHOW_DETAILS_LINK", this.createShowDetailsLinkCellRenderer());
        schema.setGridCellRendererFor("OVERVIEW", this.createOverviewCellRenderer());
        return schema;
    }

    private GridCellRenderer<BaseEntityModel<?>> createOverviewCellRenderer() {
        final String sessionID = this.viewContext.getModel().getSessionContext().getSessionID();
        return new GridCellRenderer<BaseEntityModel<?>>(){

            public Object render(BaseEntityModel<?> model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseEntityModel<?>> store, Grid<BaseEntityModel<?>> grid) {
                AbstractExternalData dataset = (AbstractExternalData)model.getBaseObject();
                return this.tryCreateOverviewLink(dataset);
            }

            private String tryCreateOverviewLink(AbstractExternalData dataset) {
                String permId = dataset.getPermId();
                String dssBaseURL = dataset.getDataStore().getHostUrl();
                String typeCode = dataset.getDataSetType().getCode();
                Set<String> typePatternsWithImageOverview = AbstractExternalDataGrid.this.getWebClientConfiguration().getDataSetTypePatternsWithImageOverview();
                if (AbstractExternalDataGrid.matches(typePatternsWithImageOverview, typeCode)) {
                    return DatasetImageOverviewUtilities.createEmbededImageHtml(dssBaseURL, permId, typeCode, sessionID);
                }
                return null;
            }
        };
    }

    private static boolean matches(Set<String> patternsSet, String value) {
        for (String pattern : patternsSet) {
            if (!value.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("CODE", "FILE_FORMAT_TYPE");
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<AbstractExternalData>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportDataSetSearchHits(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return GridUtils.getRelevantModifications(DatabaseModificationKind.ObjectKind.DATA_SET, this.getCriteriaProvider());
    }

    @Override
    protected void showEntityViewer(TableModelRowWithObject<AbstractExternalData> dataSet, boolean editMode, boolean inBackground) {
        this.showEntityInformationHolderViewer(dataSet.getObjectOrNull(), editMode, inBackground);
    }

    @Override
    protected EntityKind getEntityKindOrNull() {
        return EntityKind.DATA_SET;
    }

    public static final class SelectedAndDisplayedItems {
        private final TableExportCriteria<TableModelRowWithObject<AbstractExternalData>> displayedItemsConfig;
        private final List<TableModelRowWithObject<AbstractExternalData>> selectedItems;
        private final int displayedItemsCount;

        public SelectedAndDisplayedItems(List<TableModelRowWithObject<AbstractExternalData>> selectedItems, TableExportCriteria<TableModelRowWithObject<AbstractExternalData>> displayedItemsConfig, int displayedItemsCount) {
            this.displayedItemsConfig = displayedItemsConfig;
            this.selectedItems = selectedItems;
            this.displayedItemsCount = displayedItemsCount;
        }

        public TableExportCriteria<TableModelRowWithObject<AbstractExternalData>> getDisplayedItemsConfig() {
            return this.displayedItemsConfig;
        }

        public int getDisplayedItemsCount() {
            return this.displayedItemsCount;
        }

        public List<TableModelRowWithObject<AbstractExternalData>> getSelectedItems() {
            return this.selectedItems;
        }

        public List<AbstractExternalData> getSelectedDataSets() {
            ArrayList<AbstractExternalData> dataSets = new ArrayList<AbstractExternalData>();
            for (TableModelRowWithObject<AbstractExternalData> item : this.selectedItems) {
                dataSets.add(item.getObjectOrNull());
            }
            return dataSets;
        }

        public DisplayedOrSelectedDatasetCriteria createCriteria(boolean selected) {
            if (selected) {
                List<TableModelRowWithObject<AbstractExternalData>> items = this.getSelectedItems();
                ArrayList<String> datasetCodes = new ArrayList<String>();
                for (TableModelRowWithObject<AbstractExternalData> row : items) {
                    datasetCodes.add(row.getObjectOrNull().getCode());
                }
                return DisplayedOrSelectedDatasetCriteria.createSelectedItems(datasetCodes);
            }
            return DisplayedOrSelectedDatasetCriteria.createDisplayedItems(this.getDisplayedItemsConfig());
        }
    }
}

