/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AsyncCallbackWithProgressBar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ActionMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.IActionMenuItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.IComputationAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.SelectedOrAllDataSetsRadioProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.TextToolItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ArchivingResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedDatasetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ArchivingServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class DataSetArchivingMenu
extends TextToolItem {
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final IDelegatedActionWithResult<AbstractExternalDataGrid.SelectedAndDisplayedItems> selectedDataSetsGetter;
    private final IDelegatedAction postArchivingAction;

    public DataSetArchivingMenu(IViewContext<ICommonClientServiceAsync> viewContext, IDelegatedActionWithResult<AbstractExternalDataGrid.SelectedAndDisplayedItems> selectedDataSetsGetter, IDelegatedAction postArchivingAction) {
        super(viewContext.getMessage("menu_archiving", new Object[0]));
        this.viewContext = viewContext;
        this.postArchivingAction = postArchivingAction;
        this.selectedDataSetsGetter = selectedDataSetsGetter;
        Menu submenu = new Menu();
        this.addMenuItem(submenu, ArchivingActionMenuKind.ARCHIVING_MENU_BACKUP);
        this.addMenuItem(submenu, ArchivingActionMenuKind.ARCHIVING_MENU_ARCHIVE);
        this.addMenuItem(submenu, ArchivingActionMenuKind.ARCHIVING_MENU_UNARCHIVE);
        this.addMenuItem(submenu, ArchivingActionMenuKind.ARCHIVING_MENU_LOCK);
        this.addMenuItem(submenu, ArchivingActionMenuKind.ARCHIVING_MENU_UNLOCK);
        this.setMenu(submenu);
    }

    private final void addMenuItem(Menu submenu, ArchivingActionMenuKind menuItemKind) {
        IDelegatedAction menuItemAction = this.createArchivingMenuAction(menuItemKind.getDssTaskKind());
        submenu.add((Component)new ActionMenu((IActionMenuItem)menuItemKind, this.viewContext, menuItemAction));
    }

    private IDelegatedAction createArchivingMenuAction(final ArchivingServiceKind taskKind) {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                AbstractExternalDataGrid.SelectedAndDisplayedItems selectedAndDisplayedItems = (AbstractExternalDataGrid.SelectedAndDisplayedItems)DataSetArchivingMenu.this.selectedDataSetsGetter.execute();
                IComputationAction computationAction = DataSetArchivingMenu.this.createComputationAction(selectedAndDisplayedItems, taskKind);
                ComputationData data = new ComputationData(taskKind, computationAction, selectedAndDisplayedItems);
                this.createPerformComputationDialog(data).show();
            }

            private Window createPerformComputationDialog(ComputationData data) {
                String title = "Perform " + taskKind.getDescription();
                return new PerformArchivingDialog(DataSetArchivingMenu.this.viewContext, data, title);
            }
        };
    }

    private IComputationAction createComputationAction(final AbstractExternalDataGrid.SelectedAndDisplayedItems selectedAndDisplayedItems, final ArchivingServiceKind taskKind) {
        return new IComputationAction(){

            @Override
            public void execute(DatastoreServiceDescription service, boolean computeOnSelected) {
                DisplayedOrSelectedDatasetCriteria criteria = selectedAndDisplayedItems.createCriteria(computeOnSelected);
                switch (taskKind) {
                    case BACKUP: {
                        ((ICommonClientServiceAsync)DataSetArchivingMenu.this.viewContext.getService()).archiveDatasets(criteria, false, (AsyncCallback<ArchivingResult>)DataSetArchivingMenu.this.createArchivingDisplayCallback(taskKind.getDescription(), computeOnSelected));
                        break;
                    }
                    case ARCHIVE: {
                        ((ICommonClientServiceAsync)DataSetArchivingMenu.this.viewContext.getService()).archiveDatasets(criteria, true, (AsyncCallback<ArchivingResult>)DataSetArchivingMenu.this.createArchivingDisplayCallback(taskKind.getDescription(), computeOnSelected));
                        break;
                    }
                    case UNARCHIVE: {
                        ((ICommonClientServiceAsync)DataSetArchivingMenu.this.viewContext.getService()).unarchiveDatasets(criteria, (AsyncCallback<ArchivingResult>)DataSetArchivingMenu.this.createArchivingDisplayCallback(taskKind.getDescription(), computeOnSelected));
                        break;
                    }
                    case LOCK: {
                        ((ICommonClientServiceAsync)DataSetArchivingMenu.this.viewContext.getService()).lockDatasets(criteria, (AsyncCallback<ArchivingResult>)DataSetArchivingMenu.this.createArchivingDisplayCallback(taskKind.getDescription(), computeOnSelected));
                        break;
                    }
                    case UNLOCK: {
                        ((ICommonClientServiceAsync)DataSetArchivingMenu.this.viewContext.getService()).unlockDatasets(criteria, (AsyncCallback<ArchivingResult>)DataSetArchivingMenu.this.createArchivingDisplayCallback(taskKind.getDescription(), computeOnSelected));
                    }
                }
            }
        };
    }

    private AsyncCallback<ArchivingResult> createArchivingDisplayCallback(String actionName, boolean computeOnSelected) {
        return AsyncCallbackWithProgressBar.decorate(new ArchivingDisplayCallback(this.viewContext, actionName, computeOnSelected), "Scheduling " + actionName + "...");
    }

    private static class PerformArchivingDialog
    extends AbstractDataConfirmationDialog<ComputationData> {
        private static final int LABEL_WIDTH = 80;
        private static final int FIELD_WIDTH = 180;
        private static final int DIALOG_WIDTH = 430;
        private final IViewContext<ICommonClientServiceAsync> viewContext;
        private final SelectedOrAllDataSetsRadioProvider radioProvider;

        protected PerformArchivingDialog(IViewContext<ICommonClientServiceAsync> viewContext, ComputationData data, String title) {
            super(viewContext, data, title);
            this.viewContext = viewContext;
            this.radioProvider = new SelectedOrAllDataSetsRadioProvider(data);
            this.setWidth(430);
        }

        @Override
        protected String createMessage() {
            int size = ((ComputationData)this.data).getSelectedDataSets().size();
            String computationName = ((ComputationData)this.data).getTaskKind().getDescription();
            String requiredStatusName = this.getRequiredStatus(((ComputationData)this.data).getTaskKind()).getDescription();
            if (size == 0) {
                String msgIntroduction = this.viewContext.getMessage("no_datasets_selected", new Object[0]);
                String dictKey = "perform_archiving_on_all_datasets_msg_template";
                return this.viewContext.getMessage(dictKey, msgIntroduction, computationName, requiredStatusName);
            }
            String dictKey = "perform_archiving_on_selected_or_all_datasets_msg_template";
            return this.viewContext.getMessage(dictKey, computationName, size, requiredStatusName);
        }

        private DataSetArchivingStatus getRequiredStatus(ArchivingServiceKind taskKind) {
            switch (taskKind) {
                case BACKUP: {
                    return DataSetArchivingStatus.AVAILABLE;
                }
                case ARCHIVE: {
                    return DataSetArchivingStatus.AVAILABLE;
                }
                case UNARCHIVE: {
                    return DataSetArchivingStatus.ARCHIVED;
                }
                case LOCK: {
                    return DataSetArchivingStatus.AVAILABLE;
                }
                case UNLOCK: {
                    return DataSetArchivingStatus.LOCKED;
                }
            }
            return null;
        }

        @Override
        protected void executeConfirmedAction() {
            IComputationAction computationAction = ((ComputationData)this.data).getComputationAction();
            boolean computeOnSelected = this.getComputeOnSelected();
            computationAction.execute(null, computeOnSelected);
        }

        @Override
        protected void extendForm() {
            this.formPanel.setLabelWidth(80);
            this.formPanel.setFieldWidth(180);
            if (((ComputationData)this.data).getSelectedDataSets().size() > 0) {
                this.formPanel.add((Widget)this.createComputationDataSetsRadio());
            }
            Button confirmButton = this.getButtonById("ok");
            confirmButton.setText("Run");
        }

        private final RadioGroup createComputationDataSetsRadio() {
            return this.radioProvider.createComputationDataSetsRadio();
        }

        private boolean getComputeOnSelected() {
            return this.radioProvider.getComputeOnSelected();
        }
    }

    private final class ArchivingDisplayCallback
    extends AbstractAsyncCallback<ArchivingResult> {
        private final String actionName;
        private final boolean computeOnSelected;

        private ArchivingDisplayCallback(IViewContext<?> viewContext, String actionName, boolean computeOnSelected) {
            super(viewContext);
            this.actionName = actionName;
            this.computeOnSelected = computeOnSelected;
        }

        @Override
        public final void process(ArchivingResult result) {
            String source;
            String string = source = this.computeOnSelected ? "selected" : "provided";
            if (result.getScheduled() == 0) {
                MessageBox.info((String)this.actionName, (String)(this.actionName + " couldn't be performed on " + source + " data set(s)."), null);
            } else {
                boolean subset = result.getProvided() > result.getScheduled();
                MessageBox.info((String)this.actionName, (String)(this.actionName + " has been scheduled on " + (subset ? "a subset of " : "all ") + source + " data set(s)."), null);
                DataSetArchivingMenu.this.postArchivingAction.execute();
            }
        }
    }

    private static class ComputationData
    implements SelectedOrAllDataSetsRadioProvider.ISelectedDataSetsProvider {
        private final ArchivingServiceKind taskKind;
        private final IComputationAction computationAction;
        private final AbstractExternalDataGrid.SelectedAndDisplayedItems selectedAndDisplayedItems;

        public ComputationData(ArchivingServiceKind taskKind, IComputationAction computationAction, AbstractExternalDataGrid.SelectedAndDisplayedItems selectedAndDisplayedItems) {
            this.taskKind = taskKind;
            this.computationAction = computationAction;
            this.selectedAndDisplayedItems = selectedAndDisplayedItems;
        }

        public ArchivingServiceKind getTaskKind() {
            return this.taskKind;
        }

        public IComputationAction getComputationAction() {
            return this.computationAction;
        }

        @Override
        public List<AbstractExternalData> getSelectedDataSets() {
            List<AbstractExternalData> selectedDataSets = this.selectedAndDisplayedItems.getSelectedDataSets();
            return selectedDataSets;
        }
    }

    private static enum ArchivingActionMenuKind implements IActionMenuItem
    {
        ARCHIVING_MENU_BACKUP(ArchivingServiceKind.BACKUP),
        ARCHIVING_MENU_ARCHIVE(ArchivingServiceKind.ARCHIVE),
        ARCHIVING_MENU_UNARCHIVE(ArchivingServiceKind.UNARCHIVE),
        ARCHIVING_MENU_LOCK(ArchivingServiceKind.LOCK),
        ARCHIVING_MENU_UNLOCK(ArchivingServiceKind.UNLOCK);

        private final ArchivingServiceKind taskKind;

        private ArchivingActionMenuKind(ArchivingServiceKind taskKind) {
            this.taskKind = taskKind;
        }

        public ArchivingServiceKind getDssTaskKind() {
            return this.taskKind;
        }

        @Override
        public String getMenuId() {
            return this.name();
        }

        @Override
        public String getMenuText(IMessageProvider messageProvider) {
            return messageProvider.getMessage(this.name(), new Object[0]);
        }
    }
}

