/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report.ReportGeneratedCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report.ReportGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedDatasetCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableModelReference;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Date;

public class DataSetReportGenerator {
    public static void generate(IViewContext<ICommonClientServiceAsync> viewContext, DatastoreServiceDescription service, DisplayedOrSelectedDatasetCriteria criteria) {
        ReportGeneratedCallback.IOnReportComponentGeneratedAction action = DataSetReportGenerator.createDisplayInTabAction(viewContext, service, criteria);
        DataSetReportGenerator.generateAndInvoke(viewContext, service, criteria, action);
    }

    public static void generateAndInvoke(IViewContext<ICommonClientServiceAsync> viewContext, DatastoreServiceDescription service, DisplayedOrSelectedDatasetCriteria criteria, ReportGeneratedCallback.IOnReportComponentGeneratedAction action) {
        AsyncCallback<TableModelReference> callback = ReportGeneratedCallback.create(viewContext, service, service.getKey(), action);
        viewContext.getService().createReportFromDatasets(service, criteria, callback);
    }

    private static ReportGeneratedCallback.IOnReportComponentGeneratedAction createDisplayInTabAction(final IViewContext<ICommonClientServiceAsync> viewContext, final DatastoreServiceDescription service, DisplayedOrSelectedDatasetCriteria criteria) {
        return new ReportGeneratedCallback.IOnReportComponentGeneratedAction(){

            @Override
            public void execute(final IDisposableComponent reportComponent) {
                final String reportDate = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_MEDIUM).format(new Date());
                AbstractTabItemFactory tabFactory = new AbstractTabItemFactory(){

                    @Override
                    public ITabItem create() {
                        return DefaultTabItem.create(this.getTabTitle(), reportComponent, viewContext);
                    }

                    @Override
                    public String getId() {
                        String reportKey = service.getKey();
                        return ReportGrid.createId(reportKey + "_" + reportDate);
                    }

                    @Override
                    public HelpPageIdentifier getHelpPageIdentifier() {
                        return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.DATA_SET, HelpPageIdentifier.HelpPageAction.REPORT);
                    }

                    @Override
                    public String getTabTitle() {
                        return service.getLabel() + " (" + reportDate + ")";
                    }

                    @Override
                    public String tryGetLink() {
                        return null;
                    }
                };
                DispatcherHelper.dispatchNaviEvent(tabFactory);
            }
        };
    }
}

