/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.AbstractEntityTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.AddEntityTypeDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ScriptChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.EntityTypeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;

public class DataSetTypeGrid
extends AbstractEntityTypeGrid<DataSetType> {
    public static final String BROWSER_ID = "openbis_data-set-type-browser";
    public static final String GRID_ID = "openbis_data-set-type-browser-grid";

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext, ComponentProvider componentProvider) {
        DataSetTypeGrid grid = new DataSetTypeGrid(viewContext, componentProvider);
        return grid.asDisposableWithoutToolbar();
    }

    private DataSetTypeGrid(IViewContext<ICommonClientServiceAsync> viewContext, ComponentProvider componentProvider) {
        super(viewContext, componentProvider, BROWSER_ID, GRID_ID);
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<DataSetType>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<DataSetType>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listDataSetTypes(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<DataSetType>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportDataSetTypes(exportCriteria, callback);
    }

    @Override
    protected EntityKind getEntityKindOrNull() {
        return EntityKind.DATA_SET;
    }

    @Override
    protected void register(DataSetType dataSetType, AsyncCallback<Void> registrationCallback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).registerDataSetType(dataSetType, registrationCallback);
    }

    @Override
    protected DataSetType createNewEntityType() {
        return new DataSetType();
    }

    @Override
    protected Window createEditEntityTypeDialog(final EntityKind entityKind, final DataSetType dataSetType) {
        String code = dataSetType.getCode();
        String title = this.viewContext.getMessage("edit_type_title_template", EntityTypeUtils.translatedEntityKindForUI(this.viewContext, entityKind), code);
        return new AbstractRegistrationDialog(this.viewContext, title, this.postRegistrationCallback){
            private final DescriptionField descriptionField;
            private final TextField<String> mainDataSetPatternField;
            private final TextField<String> mainDataSetPathField;
            private final CheckBoxField deletionDisallow;
            private final ScriptChooserField scriptChooser;
            {
                super(viewContext, title, postRegistrationCallback);
                this.descriptionField = 1.createDescriptionField(DataSetTypeGrid.this.viewContext);
                FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, dataSetType.getDescription());
                this.addField((Widget)this.descriptionField);
                this.deletionDisallow = DataSetTypeGrid.this.createDeletionDisallowField();
                this.deletionDisallow.setValue(dataSetType.isDeletionDisallow());
                this.addField((Widget)this.deletionDisallow);
                this.mainDataSetPatternField = DataSetTypeGrid.this.createMainDataSetPatternField();
                FieldUtil.setValueWithUnescaping(this.mainDataSetPatternField, dataSetType.getMainDataSetPattern());
                this.addField((Widget)this.mainDataSetPatternField);
                this.mainDataSetPathField = DataSetTypeGrid.this.createMainDataSetPathField();
                FieldUtil.setValueWithUnescaping(this.mainDataSetPathField, dataSetType.getMainDataSetPath());
                this.addField((Widget)this.mainDataSetPathField);
                DialogWithOnlineHelpUtils.addHelpButton(DataSetTypeGrid.this.viewContext, this, this.createHelpPageIdentifier());
                Script script = dataSetType.getValidationScript();
                this.scriptChooser = DataSetTypeGrid.this.createScriptChooserField(DataSetTypeGrid.this.viewContext, script != null ? script.getName() : null, true, ScriptType.ENTITY_VALIDATION, EntityKind.DATA_SET);
                this.addField((Widget)this.scriptChooser);
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
                dataSetType.setDescription((String)this.descriptionField.getValue());
                dataSetType.setDeletionDisallow(this.deletionDisallow.getValue());
                dataSetType.setMainDataSetPattern((String)this.mainDataSetPatternField.getValue());
                dataSetType.setMainDataSetPath((String)this.mainDataSetPathField.getValue());
                Script script = new Script();
                script.setName((String)this.scriptChooser.getValue());
                dataSetType.setValidationScript(script);
                ((ICommonClientServiceAsync)DataSetTypeGrid.this.viewContext.getService()).updateEntityType(entityKind, dataSetType, registrationCallback);
            }

            private HelpPageIdentifier createHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.DATA_SET_TYPE, HelpPageIdentifier.HelpPageAction.EDIT);
            }
        };
    }

    @Override
    protected Window createRegisterEntityTypeDialog(String title, DataSetType newEntityType, EntityKind entityKind) {
        return new AddEntityTypeDialog<DataSetType>(this.viewContext, title, this.postRegistrationCallback, newEntityType, entityKind){
            private TextField<String> mainDataSetPatternField;
            private TextField<String> mainDataSetPathField;
            private CheckBoxField deletionDisallow;
            {
                this.deletionDisallow = DataSetTypeGrid.this.createDeletionDisallowField();
                this.addField((Widget)this.deletionDisallow);
                this.mainDataSetPatternField = DataSetTypeGrid.this.createMainDataSetPatternField();
                this.addField((Widget)this.mainDataSetPatternField);
                this.mainDataSetPathField = DataSetTypeGrid.this.createMainDataSetPathField();
                this.addField((Widget)this.mainDataSetPathField);
                DialogWithOnlineHelpUtils.addHelpButton(DataSetTypeGrid.this.viewContext, this, this.createHelpPageIdentifier());
            }

            @Override
            protected void register(DataSetType dataSetType, AsyncCallback<Void> registrationCallback) {
                dataSetType.setMainDataSetPath((String)this.mainDataSetPathField.getValue());
                dataSetType.setMainDataSetPattern((String)this.mainDataSetPatternField.getValue());
                dataSetType.setDeletionDisallow(this.deletionDisallow.getValue());
                DataSetTypeGrid.this.register(dataSetType, registrationCallback);
            }

            private HelpPageIdentifier createHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.DATA_SET_TYPE, HelpPageIdentifier.HelpPageAction.REGISTER);
            }
        };
    }

    private TextField<String> createMainDataSetPatternField() {
        TextField mainDataSetPatternField = new TextField();
        mainDataSetPatternField.setFieldLabel(this.viewContext.getMessage("main_data_set_pattern", new Object[0]));
        GWTUtils.setToolTip((Component)mainDataSetPatternField, this.viewContext.getMessage("main_data_set_pattern_tooltip", new Object[0]));
        mainDataSetPatternField.setEmptyText(this.viewContext.getMessage("main_data_set_pattern_example", new Object[0]));
        return mainDataSetPatternField;
    }

    private TextField<String> createMainDataSetPathField() {
        TextField mainDataSetPathField = new TextField();
        mainDataSetPathField.setFieldLabel(this.viewContext.getMessage("main_data_set_path", new Object[0]));
        GWTUtils.setToolTip((Component)mainDataSetPathField, this.viewContext.getMessage("main_data_set_path_tooltip", new Object[0]));
        mainDataSetPathField.setEmptyText(this.viewContext.getMessage("main_data_set_path_example", new Object[0]));
        return mainDataSetPathField;
    }

    private CheckBoxField createDeletionDisallowField() {
        String label = this.viewContext.getMessage("deletion_disallow", new Object[0]);
        CheckBoxField field = new CheckBoxField(label, false);
        GWTUtils.setToolTip((Component)field, this.viewContext.getMessage("deletion_disallow_tooltip", new Object[0]));
        return field;
    }

    @Override
    public AddEntityTypeDialog<DataSetType> getNewDialog(DataSetType newType) {
        return (AddEntityTypeDialog)this.createRegisterEntityTypeDialog("New DataSet", newType, newType.getEntityKind());
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.DATASET_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.DATASET_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }
}

