/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.DataSetTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import java.util.List;

public final class DataSetTypeSelectionWidget
extends DropDownList<DataSetTypeModel, DataSetType> {
    public static final String SUFFIX = "data-set-type";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final boolean withTypesInFile;
    private final boolean withAll;
    private final String initialCodeOrNull;

    public DataSetTypeSelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext, String idSuffix, boolean withAll, String initialCodeOrNull) {
        super(viewContext, SUFFIX + idSuffix, "data_set_type", "code", "data set type", "data set types");
        this.viewContext = viewContext;
        this.withAll = withAll;
        this.initialCodeOrNull = initialCodeOrNull;
        this.withTypesInFile = false;
        this.setAutoSelectFirst(withAll && initialCodeOrNull == null);
        this.setTemplate(GWTUtils.getTooltipTemplate("code", "tooltip"));
    }

    public DataSetTypeSelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext, String idSuffix) {
        this(viewContext, idSuffix, false, null);
    }

    public final DataSetType tryGetSelectedDataSetType() {
        return (DataSetType)((Object)super.tryGetSelected());
    }

    @Override
    protected List<DataSetTypeModel> convertItems(List<DataSetType> result) {
        return DataSetTypeModel.convert(result, this.withAll, this.withTypesInFile);
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<DataSetType>> callback) {
        this.viewContext.getService().listDataSetTypes(new ListDataSetTypesCallback(this.viewContext));
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.DATASET_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.DATASET_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }

    private void selectInitialValue() {
        if (this.initialCodeOrNull != null) {
            this.trySelectByPropertyValue("code", this.initialCodeOrNull, "Data Set Type '" + this.initialCodeOrNull + "' doesn't exist.");
            this.updateOriginalValue();
        }
    }

    private class ListDataSetTypesCallback
    extends DropDownList.ListItemsCallback {
        protected ListDataSetTypesCallback(IViewContext<?> viewContext) {
            super(DataSetTypeSelectionWidget.this, viewContext);
        }

        @Override
        public void process(List<DataSetType> result) {
            super.process(result);
            DataSetTypeSelectionWidget.this.selectInitialValue();
        }
    }
}

