/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DataSetUploadParameters;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedDatasetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public final class DataSetUploadConfirmationDialog
extends AbstractDataConfirmationDialog<List<TableModelRowWithObject<AbstractExternalData>>> {
    private static final int FIELD_WIDTH_IN_UPLOAD_DIALOG = 200;
    private static final int LABEL_WIDTH_IN_UPLOAD_DIALOG = 120;
    private final IViewContext<?> viewContext;
    private final int displayedItemsCount;
    private final IDelegatedActionWithResult<AbstractExternalDataGrid.SelectedAndDisplayedItems> selectedAndDisplayedItemsAction;
    private String cifexURL;
    private TextField<String> passwordField;
    private TextField<String> fileNameField;
    private TextArea commentField;
    private TextField<String> userField;
    private Radio uploadSelectedRadio;

    public DataSetUploadConfirmationDialog(List<TableModelRowWithObject<AbstractExternalData>> dataSets, IDelegatedActionWithResult<AbstractExternalDataGrid.SelectedAndDisplayedItems> selectedAndDisplayedItemsAction, int displayedItemsCount, IViewContext<?> viewContext) {
        super(viewContext, dataSets, viewContext.getMessage("confirm_dataset_upload_title", new Object[0]));
        this.viewContext = viewContext;
        this.displayedItemsCount = displayedItemsCount;
        this.selectedAndDisplayedItemsAction = selectedAndDisplayedItemsAction;
        this.cifexURL = viewContext.getModel().getApplicationInfo().getCifexURL();
        this.setWidth(370);
    }

    @Override
    protected String createMessage() {
        return this.viewContext.getMessage("confirm_dataset_upload_msg", this.cifexURL);
    }

    @Override
    protected final void extendForm() {
        this.formPanel.setLabelWidth(120);
        this.formPanel.setFieldWidth(200);
        this.formPanel.setBodyBorder(false);
        this.formPanel.setHeaderVisible(false);
        if (this.displayedItemsCount > 1) {
            this.formPanel.add((Widget)this.createDataSetsRadio());
        }
        this.fileNameField = new TextField();
        this.fileNameField.setFieldLabel(this.viewContext.getMessage("confirm_dataset_upload_file_name_field", new Object[0]));
        this.fileNameField.setSelectOnFocus(true);
        this.fileNameField.setMaxLength(250 + ".zip".length());
        this.fileNameField.setAutoValidate(true);
        this.fileNameField.addKeyListener(this.keyListener);
        this.formPanel.add(this.fileNameField);
        this.commentField = new TextArea();
        this.commentField.setMaxLength(1000);
        this.commentField.setFieldLabel(this.viewContext.getMessage("confirm_dataset_upload_comment_field", new Object[0]));
        this.commentField.addKeyListener(this.keyListener);
        this.commentField.setAutoValidate(true);
        this.formPanel.add((Widget)this.commentField);
        this.userField = new TextField();
        this.userField.setFieldLabel(this.viewContext.getMessage("confirm_dataset_upload_user_field", new Object[0]));
        this.userField.setValue((Object)this.viewContext.getModel().getSessionContext().getUser().getUserName());
        FieldUtil.setMandatoryFlag(this.userField, true);
        this.userField.addKeyListener(this.keyListener);
        this.userField.setAutoValidate(true);
        this.formPanel.add(this.userField);
        this.passwordField = new TextField();
        this.passwordField.setPassword(true);
        this.passwordField.setFieldLabel(this.viewContext.getMessage("confirm_dataset_upload_password_field", new Object[0]));
        FieldUtil.setMandatoryFlag(this.passwordField, false);
        this.passwordField.addKeyListener(this.keyListener);
        this.passwordField.setAutoValidate(true);
        this.formPanel.add(this.passwordField);
        DialogWithOnlineHelpUtils.addHelpButton(this.viewContext.getCommonViewContext(), (Window)this, this.createHelpPageIdentifier());
    }

    private final RadioGroup createDataSetsRadio() {
        this.uploadSelectedRadio = WidgetUtils.createRadio(this.viewContext.getMessage("only_selected_radio", ((List)this.data).size()));
        return WidgetUtils.createAllOrSelectedRadioGroup(this.uploadSelectedRadio, WidgetUtils.createRadio(this.viewContext.getMessage("all_radio", this.displayedItemsCount)), this.viewContext.getMessage("data_sets_radio_group_label", new Object[0]), ((List)this.data).size());
    }

    private boolean getUploadSelected() {
        return this.uploadSelectedRadio == null ? true : WidgetUtils.isSelected(this.uploadSelectedRadio);
    }

    @Override
    protected void executeConfirmedAction() {
        DataSetUploadParameters parameters = new DataSetUploadParameters();
        parameters.setCifexURL(this.cifexURL);
        parameters.setFileName((String)this.fileNameField.getValue());
        parameters.setComment((String)this.commentField.getValue());
        parameters.setUserID((String)this.userField.getValue());
        parameters.setPassword((String)this.passwordField.getValue());
        boolean uploadSelected = this.getUploadSelected();
        AbstractExternalDataGrid.SelectedAndDisplayedItems selectedAndDisplayedItems = this.selectedAndDisplayedItemsAction.execute();
        DisplayedOrSelectedDatasetCriteria uploadCriteria = this.createCriteria(selectedAndDisplayedItems, uploadSelected);
        this.viewContext.getCommonService().uploadDataSets(uploadCriteria, parameters, new UploadCallback((IViewContext)this.viewContext));
    }

    private DisplayedOrSelectedDatasetCriteria createCriteria(AbstractExternalDataGrid.SelectedAndDisplayedItems selectedAndDisplayedItems, boolean uploadSelected) {
        return selectedAndDisplayedItems.createCriteria(uploadSelected);
    }

    private HelpPageIdentifier createHelpPageIdentifier() {
        return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPORT_DATA, HelpPageIdentifier.HelpPageAction.ACTION);
    }

    private static final class UploadCallback
    extends AbstractAsyncCallback<String> {
        private UploadCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(String message) {
            if (message.length() > 0) {
                GWTUtils.alert("Warning", message);
            }
        }
    }
}

