/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetParentsArea;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetsArea;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.FileFormatTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ExperimentChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.SampleChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.DataSetUploadInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Widget;

public class DataSetUploadForm
extends AbstractRegistrationForm {
    private final String cifexURL;
    private final String cifexRecipient;
    private final DataSetTypeSelectionWidget dataSetTypeSelectionWidget;
    private final FileFormatTypeSelectionWidget fileTypeSelectionWidget;
    private final CheckBoxField connectedWithSampleCheckbox;
    private final SampleChooserField.SampleChooserFieldAdaptor sampleChooser;
    private final ExperimentChooserField.ExperimentChooserFieldAdaptor experimentChooser;
    private final DataSetsArea parentsArea;

    public static String createId(String suffix) {
        return "openbis_" + DataSetUploadForm.createSimpleId(suffix);
    }

    private static String createSimpleId(String suffix) {
        String withoutSuffix = "data-set-upload-panel";
        if (suffix == null) {
            return withoutSuffix;
        }
        return withoutSuffix + GWTUtils.escapeToFormId(suffix.toUpperCase());
    }

    public DataSetUploadForm(IViewContext<ICommonClientServiceAsync> viewContext, String sampleIdentifierOrNull) {
        super(viewContext, DataSetUploadForm.createSimpleId(sampleIdentifierOrNull));
        this.setResetButtonVisible(true);
        this.cifexURL = viewContext.getModel().getApplicationInfo().getCifexURL();
        this.cifexRecipient = viewContext.getModel().getApplicationInfo().getCifexRecipient();
        this.saveButton.setText(viewContext.getMessage("button_upload_data_via_cifex", new Object[0]));
        this.connectedWithSampleCheckbox = new CheckBoxField("Connected with " + viewContext.getMessage("sample", new Object[0]), false);
        this.connectedWithSampleCheckbox.setValue(true);
        this.connectedWithSampleCheckbox.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                DataSetUploadForm.this.updateFieldsVisibility();
            }
        });
        this.formPanel.add((Widget)this.connectedWithSampleCheckbox);
        this.sampleChooser = SampleChooserField.create(viewContext.getMessage("sample", new Object[0]), true, sampleIdentifierOrNull, false, false, false, viewContext, SampleTypeDisplayID.DATA_SET_UPLOAD_SAMPLE_CHOOSER, false);
        this.formPanel.add((Widget)this.sampleChooser.getField());
        this.experimentChooser = ExperimentChooserField.create(viewContext.getMessage("experiment", new Object[0]), true, null, viewContext);
        this.formPanel.add((Widget)this.experimentChooser.getField());
        this.parentsArea = new DataSetParentsArea(viewContext, DataSetUploadForm.createSimpleId(sampleIdentifierOrNull));
        this.formPanel.add((Widget)this.parentsArea);
        this.parentsArea.setMaxLength(1500);
        this.updateFieldsVisibility();
        this.dataSetTypeSelectionWidget = new DataSetTypeSelectionWidget(viewContext, DataSetUploadForm.createSimpleId(sampleIdentifierOrNull));
        this.formPanel.add((Widget)this.dataSetTypeSelectionWidget);
        FieldUtil.markAsMandatory(this.dataSetTypeSelectionWidget);
        this.fileTypeSelectionWidget = new FileFormatTypeSelectionWidget(viewContext, DataSetUploadForm.createSimpleId(sampleIdentifierOrNull));
        this.formPanel.add((Widget)this.fileTypeSelectionWidget);
        FieldUtil.markAsMandatory(this.fileTypeSelectionWidget);
        if (StringUtils.isBlank((String)this.cifexRecipient) || StringUtils.isBlank((String)this.cifexURL)) {
            this.formPanel.disable();
            this.infoBox.displayError(viewContext.getMessage("message_no_external_upload_service", new Object[0]));
        }
    }

    private void updateFieldsVisibility() {
        boolean connectedWithSample = this.isConnectedWithSample();
        FieldUtil.setVisibility(connectedWithSample, this.sampleChooser.getField());
        FieldUtil.setVisibility(!connectedWithSample, new Field[]{this.experimentChooser.getField(), this.parentsArea});
    }

    public static DatabaseModificationAwareComponent create(IViewContext<ICommonClientServiceAsync> viewContext, String sampleIdentifierOrNull) {
        DataSetUploadForm form = new DataSetUploadForm(viewContext, sampleIdentifierOrNull);
        IDatabaseModificationObserver observer = form.createDatabaseModificationObserver();
        return new DatabaseModificationAwareComponent((Component)form, observer);
    }

    private IDatabaseModificationObserver createDatabaseModificationObserver() {
        CompositeDatabaseModificationObserver observer = new CompositeDatabaseModificationObserver();
        observer.addObserver(this.dataSetTypeSelectionWidget);
        observer.addObserver(this.fileTypeSelectionWidget);
        return observer;
    }

    @Override
    protected void submitValidForm() {
        String sample = this.extractSampleIdentifier();
        String experiment = this.extractExperimentIdentifier();
        String dataSetType = this.extractDataSetTypeCode();
        String fileType = this.extractFileTypeCode();
        String[] parents = this.extractParentDatasetCodes();
        String comment = this.isConnectedWithSample() != false ? this.encodeDataSetInfo(sample, dataSetType, fileType) : this.encodeDataSetInfo(experiment, parents, dataSetType, fileType);
        WindowUtils.openWindow(DataSetUploadForm.encodeCifexRequest(this.cifexURL, this.cifexRecipient, comment));
    }

    private Boolean isConnectedWithSample() {
        return this.connectedWithSampleCheckbox.getValue();
    }

    private String extractSampleIdentifier() {
        return this.sampleChooser.getValue();
    }

    private String extractExperimentIdentifier() {
        ExperimentIdentifier identifierOrNull = this.experimentChooser.tryToGetValue();
        return identifierOrNull == null ? null : identifierOrNull.getIdentifier();
    }

    private String extractDataSetTypeCode() {
        return ((DataSetType)((Object)this.dataSetTypeSelectionWidget.tryGetSelected())).getCode();
    }

    private String extractFileTypeCode() {
        return ((FileFormatType)((Object)this.fileTypeSelectionWidget.tryGetSelected())).getCode();
    }

    protected String[] extractParentDatasetCodes() {
        return this.parentsArea.tryGetModifiedDataSetCodes();
    }

    private String encodeDataSetInfo(String sample, String dataSetType, String fileType) {
        return DataSetUploadInfo.DataSetUploadInfoHelper.encodeAsCifexComment(new DataSetUploadInfo(sample, null, null, dataSetType, fileType));
    }

    private String encodeDataSetInfo(String experiment, String[] parents, String dataSetType, String fileType) {
        return DataSetUploadInfo.DataSetUploadInfoHelper.encodeAsCifexComment(new DataSetUploadInfo(null, experiment, parents, dataSetType, fileType));
    }

    private static String encodeCifexRequest(String cifexUrl, String recipient, String comment) {
        URLMethodWithParameters url = new URLMethodWithParameters(cifexUrl);
        url.addParameterWithoutEncoding("comment", comment);
        url.addParameterWithoutEncoding("recipients", recipient);
        return URL.encode((String)url.toString());
    }
}

