/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import java.util.ArrayList;
import java.util.List;

public class DatastoreServiceDescriptionModel
extends SimplifiedBaseModelData {
    private static final long serialVersionUID = 1L;

    public static DatastoreServiceDescriptionModel createFakeReportingServiceModel(String label) {
        DatastoreServiceDescription service = DatastoreServiceDescription.reporting(label, label, null, null, null);
        return new DatastoreServiceDescriptionModel(service);
    }

    public DatastoreServiceDescriptionModel(DatastoreServiceDescription description) {
        this.set("object", description);
        this.set("label", description.getLabel());
        this.set("description", description.getServiceKind().getDescription() + ": " + description.getLabel());
    }

    public static final List<DatastoreServiceDescriptionModel> convert(List<DatastoreServiceDescription> services, AbstractExternalData datasetOrNull) {
        ArrayList<DatastoreServiceDescriptionModel> result = new ArrayList<DatastoreServiceDescriptionModel>();
        for (DatastoreServiceDescription service : services) {
            if (datasetOrNull != null && !DatastoreServiceDescription.isMatching(service, datasetOrNull)) continue;
            result.add(new DatastoreServiceDescriptionModel(service));
        }
        return result;
    }

    public final DatastoreServiceDescription getBaseObject() {
        return (DatastoreServiceDescription)this.get("object");
    }
}

