/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.AddTypeDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.TextToolItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class FileFormatTypeGrid
extends TypedTableGrid<FileFormatType> {
    public static final String BROWSER_ID = "openbis_file-format-type-browser";
    public static final String GRID_ID = "openbis_file-format-type-browser-grid";
    public static final String ADD_NEW_TYPE_BUTTON_ID = "openbis_file-format-type-browser-grid-add_new_type_button";
    private final IDelegatedAction postRegistrationCallback = this.createRefreshGridAction();

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        FileFormatTypeGrid grid = new FileFormatTypeGrid(viewContext);
        return grid.asDisposableWithoutToolbar();
    }

    private FileFormatTypeGrid(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.FILE_FORMAT_TYPE_BROWSER_GRID);
        this.extendBottomToolbar();
        this.allowMultipleSelection();
    }

    private final void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        TextToolItem createItem = new TextToolItem(this.viewContext.getMessage("add_new_type_button", new Object[0]), new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                FileFormatTypeGrid.this.createRegisterFileTypeDialog().show();
            }
        });
        createItem.setId(ADD_NEW_TYPE_BUTTON_ID);
        this.addButton(createItem);
        Button editButton = this.createSelectedItemButton(this.viewContext.getMessage("edit_type_button", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<FileFormatType>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<FileFormatType>> selectedItem, boolean keyPressed) {
                FileFormatType entityType = selectedItem.getBaseObject().getObjectOrNull();
                FileFormatTypeGrid.this.createEditEntityTypeDialog(entityType).show();
            }
        });
        this.addButton(editButton);
        Button deleteButton = this.createDeleteButton(this.viewContext);
        this.enableButtonOnSelectedItems(deleteButton);
        this.addButton(deleteButton);
        this.addEntityOperationsSeparator();
    }

    private Window createRegisterFileTypeDialog() {
        String title = this.viewContext.getMessage("add_type_title_template", "File");
        return new AddTypeDialog<FileFormatType>(this.viewContext, title, this.postRegistrationCallback, new FileFormatType()){

            @Override
            protected void register(FileFormatType type, AsyncCallback<Void> registrationCallback) {
                ((ICommonClientServiceAsync)FileFormatTypeGrid.this.viewContext.getService()).registerFileType(type, registrationCallback);
            }
        };
    }

    private Button createDeleteButton(final IViewContext<ICommonClientServiceAsync> context) {
        Button deleteButton = new Button(context.getMessage("button_delete", new Object[0]));
        deleteButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                List types = FileFormatTypeGrid.this.getSelectedItems();
                if (types.isEmpty()) {
                    return;
                }
                final ArrayList<String> selectedTypeCodes = new ArrayList<String>();
                for (BaseEntityModel model : types) {
                    FileFormatType term = (FileFormatType)((Object)model.getBaseObject().getObjectOrNull());
                    selectedTypeCodes.add(term.getCode());
                }
                ConfirmationDialog confirmationDialog = new ConfirmationDialog(context.getMessage("delete_confirmation_title", new Object[0]), context.getMessage("delete_confirmation_message", StringUtils.joinList(selectedTypeCodes))){

                    @Override
                    protected void onYes() {
                        FileFormatTypeGrid.this.viewContext.getCommonService().deleteFileFormatTypes(selectedTypeCodes, new RefreshCallback(FileFormatTypeGrid.this.viewContext));
                    }
                };
                confirmationDialog.show();
            }
        });
        return deleteButton;
    }

    private Window createEditEntityTypeDialog(final FileFormatType type) {
        String code = type.getCode();
        String title = this.viewContext.getMessage("edit_type_title_template", type.getDescription(), code);
        return new AbstractRegistrationDialog(this.viewContext, title, this.postRegistrationCallback){
            private final DescriptionField descriptionField;
            {
                super(viewContext, title, postRegistrationCallback);
                this.descriptionField = 5.createDescriptionField(FileFormatTypeGrid.this.viewContext);
                FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, type.getDescription());
                this.addField((Widget)this.descriptionField);
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
                type.setDescription((String)this.descriptionField.getValue());
                ((ICommonClientServiceAsync)FileFormatTypeGrid.this.viewContext.getService()).updateFileFormatType(type, registrationCallback);
            }
        };
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<FileFormatType>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<FileFormatType>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        return schema;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<FileFormatType>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<FileFormatType>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listFileTypes(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<FileFormatType>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportFileTypes(exportCriteria, callback);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    private final class RefreshCallback
    extends AbstractAsyncCallback<Void> {
        private RefreshCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Void result) {
            FileFormatTypeGrid.this.refresh();
        }
    }
}

