/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AsyncCallbackWithProgressBar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion.DeletionForceOptions;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion.DeletionGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedIdHolderCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public final class PermanentDeletionConfirmationDialog
extends AbstractDataConfirmationDialog<List<Deletion>> {
    private static final int LABEL_WIDTH = 60;
    private static final int FIELD_WIDTH = 200;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final AsyncCallback<Void> callback;
    private final DeletionForceOptions forceOptions;
    private final DeletionGrid.DisplayedAndSelectedDeletions selectedAndDisplayedItems;
    private Radio onlySelectedRadio;
    private Radio allRadio;

    public PermanentDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, DeletionGrid.DisplayedAndSelectedDeletions selectedAndDisplayedItems, AsyncCallback<Void> callback) {
        super(viewContext, null, viewContext.getMessage("permanent_deletions_confirmation_title", new Object[0]));
        this.setStyleName("permanentDeletionConfirmationDialog");
        this.viewContext = viewContext;
        this.callback = new DeletionAsyncCallback(callback);
        this.forceOptions = new DeletionForceOptions(viewContext);
        this.selectedAndDisplayedItems = selectedAndDisplayedItems;
        this.setId("deletion-confirmation-dialog");
    }

    @Override
    protected void executeConfirmedAction() {
        DisplayedOrSelectedIdHolderCriteria<TableModelRowWithObject<Deletion>> criteria = this.selectedAndDisplayedItems.createCriteria(WidgetUtils.isSelected(this.onlySelectedRadio));
        this.viewContext.getCommonService().deletePermanently(criteria, this.forceOptions.getForceToDeleteDependentDeletionSetsValue(), this.forceOptions.getForceDisallowedTypesValue(), AsyncCallbackWithProgressBar.decorate(this.callback, this.viewContext.getMessage("permanent_deletions_progress", new Object[0])));
    }

    @Override
    protected String createMessage() {
        if (WidgetUtils.isSelected(this.onlySelectedRadio)) {
            return this.viewContext.getMessage("permanent_deletions_selected_confirmation_msg", this.selectedAndDisplayedItems.getSelectedDeletions().size());
        }
        return this.viewContext.getMessage("permanent_deletions_all_confirmation_msg", new Object[0]);
    }

    @Override
    protected void extendForm() {
        this.formPanel.setLabelWidth(60);
        this.formPanel.setFieldWidth(200);
        this.onlySelectedRadio = WidgetUtils.createRadio(this.viewContext.getMessage("only_selected_radio", this.selectedAndDisplayedItems.getSelectedDeletions().size()));
        this.allRadio = WidgetUtils.createRadio(this.viewContext.getMessage("all_radio", this.selectedAndDisplayedItems.getDisplayedItemsCount()));
        RadioGroup radioGroup = WidgetUtils.createAllOrSelectedRadioGroup(this.onlySelectedRadio, this.allRadio, this.viewContext.getMessage("deletion_radio_group_label", new Object[0]), this.selectedAndDisplayedItems.getSelectedDeletions().size(), this.createRefreshMessageAction());
        radioGroup.setStyleName("gray-delete-radios");
        this.formPanel.add((Widget)radioGroup);
        this.formPanel.add((Widget)this.forceOptions);
    }

    public class DeletionAsyncCallback
    implements AsyncCallback<Void> {
        private AsyncCallback<Void> callback;

        public DeletionAsyncCallback(AsyncCallback<Void> callback) {
            this.callback = callback;
        }

        public void onFailure(Throwable caught) {
            String message = caught.getMessage();
            if (message.startsWith("Permanent deletion not possible because ")) {
                this.callback.onFailure((Throwable)new UserFailureException(message + "\n\nYou have to delete them permanently before you can delete the selected deletion sets or you check the check boxes 'Force' and 'Force dependent deletions' the next time."));
            } else {
                this.callback.onFailure(caught);
            }
        }

        public void onSuccess(Void result) {
            this.callback.onSuccess((Object)result);
        }
    }
}

